/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.location.LocationManager;
import android.os.Build;
import android.os.PowerManager;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.TextView;
import androidx.core.app.NotificationManagerCompat;
import com.bfcy.base.log.Logger;
import com.bfcy.base.service.RestartAppService;
import com.bfcy.base.utils.ActivityDequeManager;
import com.bfcy.base.utils.DisplayUtil;
import com.bfcy.base.utils.TimeUtil;
import java.util.List;
import java.util.Locale;

public class AppUtils {
    private static final String TAG = "AppUtils";

    public static void logLocalInfo(Context context) {
        TimeUtil.logTimeZone();
        AppUtils.logAppInfo(context);
        AppUtils.logPhoneInfo();
        DisplayUtil.logScreenInfo(context);
    }

    public static void logAppInfo(Context context) {
        Log.i((String)TAG, (String)("LocalInfo--AppInfo--AppName: " + AppUtils.getAppName(context)));
        Log.i((String)TAG, (String)("LocalInfo--AppInfo--AppPackageName: " + AppUtils.getAppPackageName(context)));
        Log.i((String)TAG, (String)("LocalInfo--AppInfo--AppVersionName: " + AppUtils.getAppVersionName(context)));
        Log.i((String)TAG, (String)("LocalInfo--AppInfo--AppVersionCode: " + AppUtils.getAppVersionCode(context)));
    }

    public static void logPhoneInfo() {
        Log.i((String)TAG, (String)("LocalInfo--PhoneInfo--PhoneBrand: " + Build.BRAND));
        Log.i((String)TAG, (String)("LocalInfo--PhoneInfo--PhoneModel: " + Build.MODEL));
        Log.i((String)TAG, (String)("LocalInfo--PhoneInfo--PhoneSystemVersion: " + Build.VERSION.RELEASE));
    }

    public static String getAppName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 16384);
            int labelRes = packageInfo.applicationInfo.labelRes;
            return context.getResources().getString(labelRes);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAppPackageName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.packageName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static int getAppVersionCode(Context context) {
        try {
            PackageManager packageManager = context.getPackageManager();
            PackageInfo packageInfo = packageManager.getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public static String getLanguage(Context context) {
        Locale locale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(0) : context.getResources().getConfiguration().locale;
        return locale.getLanguage();
    }

    public static String getCountry(Context context) {
        Locale locale = Build.VERSION.SDK_INT >= 24 ? context.getResources().getConfiguration().getLocales().get(1) : context.getResources().getConfiguration().locale;
        return locale.getCountry();
    }

    public static boolean isServiceRunning(Context mContext, String serviceName) {
        ActivityManager activityManager = (ActivityManager)mContext.getSystemService("activity");
        List serviceList = activityManager.getRunningServices(30);
        if (serviceList.size() <= 0) {
            return false;
        }
        for (int i = 0; i < serviceList.size(); ++i) {
            if (!((ActivityManager.RunningServiceInfo)serviceList.get((int)i)).service.getClassName().equals(serviceName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAppRunning(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List list = null;
        if (activityManager != null) {
            list = activityManager.getRunningTasks(100);
        }
        if (list == null || list.size() <= 0) {
            Logger.i(TAG, "isAppRunning--RunningTasksList: 0");
            return false;
        }
        Logger.i(TAG, "isAppRunning--RunningTasksList: " + list.size());
        for (ActivityManager.RunningTaskInfo info : list) {
            if (info.baseActivity == null) continue;
            Logger.i(TAG, "isAppRunning--RunningTasksName: " + info.baseActivity.getPackageName());
        }
        for (ActivityManager.RunningTaskInfo info : list) {
            if (info.baseActivity == null || !info.baseActivity.getPackageName().equals(context.getPackageName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAppForeground(Context context) {
        if (context != null) {
            ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
            if (activityManager == null) {
                return false;
            }
            List processes = activityManager.getRunningAppProcesses();
            for (ActivityManager.RunningAppProcessInfo processInfo : processes) {
                if (!processInfo.processName.equals(context.getPackageName())) continue;
                Logger.i(TAG, "isAppForeground--100\u5728\u524d\u53f0--importance: " + processInfo.importance);
                if (processInfo.importance != 100) continue;
                return true;
            }
        }
        return false;
    }

    public static void wakeUpScreen(Context context) {
        Logger.i(TAG, "wakeUpScreen--\u6267\u884c");
        PowerManager powerManager = (PowerManager)context.getSystemService("power");
        PowerManager.WakeLock wakeLock = powerManager.newWakeLock(0x10000006, "bright");
        wakeLock.acquire(10000L);
        wakeLock.release();
    }

    public static void unlockScreen(Context context) {
        Logger.i(TAG, "unlockScreen--\u6267\u884c");
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        KeyguardManager.KeyguardLock keyguardLock = keyguardManager.newKeyguardLock("unLock");
        keyguardLock.disableKeyguard();
    }

    public static void restartAPP(Context context, long delay) {
        Intent intent = new Intent(context, RestartAppService.class);
        intent.putExtra("PackageName", context.getPackageName());
        intent.putExtra("delay", delay);
        context.startService(intent);
        ActivityDequeManager.getInstance().finishAllActivity();
    }

    public static void restartAPP(Context context) {
        AppUtils.restartAPP(context, 1000L);
    }

    public static void showSoftInput(Context context, EditText et) {
        et.postDelayed(() -> {
            et.setFocusable(true);
            et.setFocusableInTouchMode(true);
            et.requestFocus();
            InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
            imm.showSoftInput((View)et, 1);
        }, 200L);
    }

    public static void hideSoftInput(Activity context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        if (imm.isActive() && context.getCurrentFocus() != null && context.getCurrentFocus().getWindowToken() != null) {
            imm.hideSoftInputFromWindow(context.getCurrentFocus().getWindowToken(), 2);
        }
    }

    public static void setMarqueeText(TextView text) {
        text.setEllipsize(TextUtils.TruncateAt.MARQUEE);
        text.setSingleLine(true);
        text.setSelected(true);
        text.setFocusable(true);
        text.setFocusableInTouchMode(true);
        text.setMarqueeRepeatLimit(-1);
    }

    public static boolean isNotificationEnabled(Context context) {
        boolean enable = true;
        try {
            enable = NotificationManagerCompat.from((Context)context).areNotificationsEnabled();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enable;
    }

    public static boolean isLocationServiceEnable(Context context) {
        LocationManager locationManager = (LocationManager)context.getSystemService("location");
        boolean gps = locationManager.isProviderEnabled("gps");
        boolean network = locationManager.isProviderEnabled("network");
        Logger.i(TAG, "isLocationServiceEnable--gps: " + gps + "; network: " + network);
        return gps || network;
    }
}

