/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.content.Context;
import android.os.Vibrator;
import android.view.ViewTreeObserver;
import android.widget.TextView;
import com.bfcy.base.BaseApp;
import com.bfcy.base.utils.ToastUtil;

public class CommonUtils {
    public static void showToast(String msg) {
        CommonUtils.showToast(msg, 1);
    }

    public static void showToast(int resId) {
        CommonUtils.showToast(CommonUtils.getString(resId), 1);
    }

    public static void showToast(String msg, int length) {
        ToastUtil.showToast((Context)BaseApp.getInstance(), msg, length);
    }

    public static void showToast(int resId, int length) {
        CommonUtils.showToast(CommonUtils.getString(resId), length);
    }

    public static void showImageToast(int iconResId, String tips) {
        CommonUtils.showImageToast(iconResId, tips, 0);
    }

    public static void showImageToast(int iconResId, int tipsResId) {
        CommonUtils.showImageToast(iconResId, CommonUtils.getString(tipsResId), 0);
    }

    public static void showImageToast(int iconResId, int tipsResId, int length) {
        CommonUtils.showImageToast(iconResId, CommonUtils.getString(tipsResId), length);
    }

    public static void showImageToast(int iconResId, String tips, int length) {
        ToastUtil.showImageToast((Context)BaseApp.getInstance(), iconResId, tips, length);
    }

    public static String getString(int resId) {
        return BaseApp.getInstance().getString(resId);
    }

    public static void startVibrate(Context context, long milliseconds) {
        Vibrator vib = (Vibrator)context.getSystemService("vibrator");
        vib.vibrate(milliseconds);
    }

    private void setTextGravity(final TextView textView) {
        ViewTreeObserver vto = textView.getViewTreeObserver();
        vto.addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                double w0 = textView.getWidth();
                double w1 = textView.getPaint().measureText(textView.getText().toString());
                if (w1 > w0) {
                    textView.setGravity(0x800003);
                } else {
                    textView.setGravity(0x800005);
                }
            }
        });
    }
}

