/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.os.Environment;
import android.os.Process;
import androidx.annotation.NonNull;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;

public class CrashHandler
implements Thread.UncaughtExceptionHandler {
    private static final String PATH = Environment.getExternalStorageDirectory().getAbsolutePath();
    private static final String FILE_NAME_SUFFIX = ".trace";
    private static CrashHandler sInstance = new CrashHandler();
    private Thread.UncaughtExceptionHandler mDefaultCrashHandler;
    private Context mContext;
    private String crashString = "";

    private CrashHandler() {
    }

    public static CrashHandler getInstance() {
        return sInstance;
    }

    public void init(@NonNull Context context) {
        this.mDefaultCrashHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(this);
        this.mContext = context.getApplicationContext();
    }

    public static String getStackTraceString(Throwable tr) {
        if (tr == null) {
            return "";
        }
        for (Throwable t = tr; t != null; t = t.getCause()) {
            if (!(t instanceof UnknownHostException)) continue;
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    @Override
    public void uncaughtException(Thread t, Throwable e) {
        try {
            StringWriter result = new StringWriter();
            PrintWriter printWriter = new PrintWriter(result);
            e.printStackTrace(printWriter);
            if (this.crashString.equals(((Object)result).toString())) {
                return;
            }
            this.crashString = ((Object)result).toString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("crash", this.crashString);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        e.printStackTrace();
        if (this.mDefaultCrashHandler != null) {
            this.mDefaultCrashHandler.uncaughtException(t, e);
        } else {
            Process.killProcess((int)Process.myPid());
        }
    }

    private void exportExceptionToSDCard(@NonNull Throwable e) {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return;
        }
        String time = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA).format(new Date());
        File file = new File(PATH + File.separator + time + FILE_NAME_SUFFIX);
        try {
            PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            pw.println(time);
            pw.println(this.appendPhoneInfo());
            e.printStackTrace(pw);
            pw.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (PackageManager.NameNotFoundException e1) {
            e1.printStackTrace();
        }
    }

    private String appendPhoneInfo() throws PackageManager.NameNotFoundException {
        PackageManager pm = this.mContext.getPackageManager();
        PackageInfo pi = pm.getPackageInfo(this.mContext.getPackageName(), 1);
        StringBuilder sb = new StringBuilder();
        sb.append("App Version: ");
        sb.append(pi.versionName);
        sb.append("_");
        sb.append(pi.versionCode + "\n");
        sb.append("OS Version: ");
        sb.append(Build.VERSION.RELEASE);
        sb.append("_");
        sb.append(Build.VERSION.SDK_INT + "\n");
        sb.append("Vendor: ");
        sb.append(Build.MANUFACTURER + "\n");
        sb.append("Model: ");
        sb.append(Build.MODEL + "\n");
        sb.append("CPU: ");
        if (Build.VERSION.SDK_INT >= 21) {
            sb.append(Arrays.toString(Build.SUPPORTED_ABIS));
        } else {
            sb.append(Build.CPU_ABI);
        }
        return sb.toString();
    }
}

