/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

public class Crc16Util {
    public static byte[] convertSingleData(String addr, String type, String relay, String order) {
        int a = Integer.valueOf(addr);
        int b = Integer.valueOf(type);
        int c = Integer.valueOf(relay);
        int d = Integer.valueOf(order);
        byte[] bytes = new byte[]{(byte)a, (byte)b, 0, (byte)c, (byte)d, 0};
        return Crc16Util.getData(bytes);
    }

    public static byte[] convertMultiData(String addr, String type, String start, String number, String order) {
        int a = Integer.valueOf(addr);
        int b = Integer.valueOf(type);
        int c = Integer.valueOf(start);
        int d = Integer.valueOf(number);
        int e = Integer.valueOf(order);
        byte[] bytes = new byte[]{(byte)a, (byte)b, 0, (byte)c, 0, (byte)d, 1, (byte)e};
        return Crc16Util.getData(bytes);
    }

    public static byte[] getData(String ... strings) {
        byte[] data = new byte[]{};
        for (int i = 0; i < strings.length; ++i) {
            int x = Integer.parseInt(strings[i], 16);
            byte n = (byte)x;
            byte[] buffer = new byte[data.length + 1];
            byte[] aa = new byte[]{n};
            System.arraycopy(data, 0, buffer, 0, data.length);
            System.arraycopy(aa, 0, buffer, data.length, aa.length);
            data = buffer;
        }
        return Crc16Util.getData(data);
    }

    private static byte[] getData(byte[] aa) {
        byte[] bb = Crc16Util.getCrc16(aa);
        byte[] cc = new byte[aa.length + bb.length];
        System.arraycopy(aa, 0, cc, 0, aa.length);
        System.arraycopy(bb, 0, cc, aa.length, bb.length);
        return cc;
    }

    private static byte[] getCrc16(byte[] arr_buff) {
        int len = arr_buff.length;
        int crc = 65535;
        for (int i = 0; i < len; ++i) {
            crc = crc & 0xFF00 | crc & 0xFF ^ arr_buff[i] & 0xFF;
            for (int j = 0; j < 8; ++j) {
                if ((crc & 1) > 0) {
                    crc >>= 1;
                    crc ^= 0xA001;
                    continue;
                }
                crc >>= 1;
            }
        }
        return Crc16Util.intToBytes(crc);
    }

    private static byte[] intToBytes(int value) {
        byte[] src = new byte[2];
        src[1] = (byte)(value >> 8 & 0xFF);
        src[0] = (byte)(value & 0xFF);
        return src;
    }

    public static String byteTo16String(byte[] data) {
        StringBuffer buffer = new StringBuffer();
        for (byte b : data) {
            buffer.append(Crc16Util.byteTo16String(b));
        }
        return buffer.toString();
    }

    public static String byteTo16String(byte b) {
        StringBuffer buffer = new StringBuffer();
        byte aa = b;
        if (aa < 0) {
            buffer.append(Integer.toString(aa + 256, 16) + " ");
        } else if (aa == 0) {
            buffer.append("00 ");
        } else if (aa > 0 && aa <= 15) {
            buffer.append("0" + Integer.toString(aa, 16) + " ");
        } else if (aa > 15) {
            buffer.append(Integer.toString(aa, 16) + " ");
        }
        return buffer.toString();
    }
}

