/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.TextView;
import com.bfcy.base.R;
import com.bfcy.base.utils.AppUtils;
import com.google.android.material.textfield.TextInputLayout;

public class DialogUtils {
    public static Dialog showDialog(Context context, CharSequence message, OnClickListener positiveListener, OnClickListener negativeListener) {
        if (negativeListener == null) {
            negativeListener = (dialog, strings) -> dialog.dismiss();
        }
        return DialogUtils.showCommonDialog(context, null, message, null, positiveListener, null, negativeListener, true);
    }

    public static Dialog showDialog(Context context, CharSequence title, CharSequence message, CharSequence positiveBtnName, OnClickListener positiveListener, CharSequence negativeBtnName, OnClickListener negativeListener, boolean cancelable) {
        if (negativeListener == null) {
            negativeListener = (dialog, strings) -> dialog.dismiss();
        }
        return DialogUtils.showCommonDialog(context, title, message, positiveBtnName, positiveListener, negativeBtnName, negativeListener, cancelable);
    }

    public static Dialog showConfirmDialog(Context context, CharSequence message, OnClickListener positiveListener) {
        return DialogUtils.showDialog(context, null, message, null, positiveListener, null, null, true);
    }

    private static Dialog showCommonDialog(Context context, CharSequence title, CharSequence message, CharSequence positiveBtnName, OnClickListener positiveListener, CharSequence negativeBtnName, OnClickListener negativeListener, boolean cancelable) {
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            return null;
        }
        Dialog dialog = new Dialog(context, R.style.Dialog_Common);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.dialog_util_common, null);
        TextView tvDialogTitle = (TextView)view.findViewById(R.id.tvDialogTitle);
        TextView tvDialogMessage = (TextView)view.findViewById(R.id.tvDialogMessage);
        View layoutNegativeButton = view.findViewById(R.id.layoutNegativeButton);
        TextView negativeButton = (TextView)view.findViewById(R.id.negativeButton);
        TextView dividingLine = (TextView)view.findViewById(R.id.dividingLine);
        TextView positiveButton = (TextView)view.findViewById(R.id.positiveButton);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            tvDialogTitle.setText(title);
        }
        if (!TextUtils.isEmpty((CharSequence)message)) {
            tvDialogMessage.setText(message);
        }
        if (!TextUtils.isEmpty((CharSequence)negativeBtnName)) {
            negativeButton.setText(negativeBtnName);
        }
        if (!TextUtils.isEmpty((CharSequence)positiveBtnName)) {
            positiveButton.setText(positiveBtnName);
        }
        if (negativeListener != null) {
            negativeButton.setOnClickListener(v -> negativeListener.onClick((DialogInterface)dialog, ""));
        } else {
            layoutNegativeButton.setVisibility(8);
            dividingLine.setVisibility(8);
        }
        positiveButton.setOnClickListener(v -> {
            if (positiveListener != null) {
                positiveListener.onClick((DialogInterface)dialog, "");
            } else {
                dialog.dismiss();
            }
        });
        dialog.setCancelable(cancelable);
        Window dialogWindow = dialog.getWindow();
        if (dialogWindow != null) {
            WindowManager.LayoutParams attributes = dialogWindow.getAttributes();
            attributes.width = -2;
            attributes.height = -2;
            dialogWindow.setAttributes(attributes);
        }
        dialog.setContentView(view);
        dialog.show();
        return dialog;
    }

    public static Dialog showPasswordDialog(Context context, CharSequence title, OnClickListener positiveListener, OnClickListener negativeListener) {
        if (context instanceof Activity && ((Activity)context).isFinishing()) {
            return null;
        }
        Dialog dialog = new Dialog(context, R.style.Dialog_Common);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.dialog_util_password, null);
        TextView tvDialogTitle = (TextView)view.findViewById(R.id.tvDialogTitle);
        TextInputLayout layoutPwd = (TextInputLayout)view.findViewById(R.id.layoutPwd);
        EditText etPassword = (EditText)view.findViewById(R.id.etPassword);
        TextView negativeButton = (TextView)view.findViewById(R.id.negativeButton);
        TextView positiveButton = (TextView)view.findViewById(R.id.positiveButton);
        if (!TextUtils.isEmpty((CharSequence)title)) {
            tvDialogTitle.setText(title);
        }
        layoutPwd.setVisibility(0);
        positiveButton.setText((CharSequence)"\u8fde\u63a5");
        negativeButton.setOnClickListener(v -> {
            if (negativeListener != null) {
                negativeListener.onClick((DialogInterface)dialog, "");
            } else {
                dialog.dismiss();
            }
        });
        positiveButton.setOnClickListener(v -> {
            if (positiveListener != null) {
                String pwd = etPassword.getText().toString().trim();
                positiveListener.onClick((DialogInterface)dialog, pwd);
            } else {
                dialog.dismiss();
            }
        });
        dialog.setCancelable(true);
        Window dialogWindow = dialog.getWindow();
        if (dialogWindow != null) {
            WindowManager.LayoutParams attributes = dialogWindow.getAttributes();
            attributes.width = -2;
            attributes.height = -2;
            dialogWindow.setAttributes(attributes);
        }
        dialog.setContentView(view);
        dialog.show();
        AppUtils.showSoftInput(context, etPassword);
        return dialog;
    }

    public static interface OnClickListener {
        public void onClick(DialogInterface var1, String ... var2);
    }
}

