/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.app.Activity;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Display;
import android.view.Window;
import android.view.WindowManager;
import com.bfcy.base.log.Logger;

public class DisplayUtil {
    private static final String TAG = "DisplayUtil";
    public static int screenWidthPx;
    public static int screenhightPx;
    public static float density;
    public static int densityDPI;
    public static float screenWidthDip;
    public static float screenHightDip;

    public static void logScreenInfo(Context context) {
        Log.i((String)TAG, (String)("LocalInfo--ScreenInfo--WidthPixel: " + DisplayUtil.getWindowsWidth(context)));
        Log.i((String)TAG, (String)("LocalInfo--ScreenInfo--HeightPixel: " + DisplayUtil.getWindowsHeight(context)));
    }

    public static int dp2px(Context context, float dipValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    public static int px2dp(Context context, float pxValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(pxValue / scale + 0.5f);
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int px2sp(Context context, float pxValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(pxValue / fontScale + 0.5f);
    }

    public static int getWindowsWidth(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Logger.i(TAG, "--->DisplayUtil--getWindowsWidth: " + displayMetrics.widthPixels);
        return displayMetrics.widthPixels;
    }

    public static int getWindowsHeight(Context context) {
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        Logger.i(TAG, "--->DisplayUtil--getWindowsHeight: " + displayMetrics.heightPixels);
        return displayMetrics.heightPixels;
    }

    public static void getScreenRelatedInformation(Context context) {
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        if (windowManager != null) {
            DisplayMetrics outMetrics = new DisplayMetrics();
            windowManager.getDefaultDisplay().getMetrics(outMetrics);
            int widthPixels = outMetrics.widthPixels;
            int heightPixels = outMetrics.heightPixels;
            int densityDpi = outMetrics.densityDpi;
            float density = outMetrics.density;
            float scaledDensity = outMetrics.scaledDensity;
            Logger.i(TAG, "--->DisplayUtil--ScreenRelatedInfo: widthPixels = " + widthPixels + ",heightPixels = " + heightPixels + ",densityDpi = " + densityDpi + ",density = " + density + ",scaledDensity = " + scaledDensity);
        }
    }

    public static void getWindowsSize(Activity activity) {
        Display defaultDisplay = activity.getWindowManager().getDefaultDisplay();
        Point point = new Point();
        defaultDisplay.getSize(point);
        int x = point.x;
        int y = point.y;
        Logger.i(TAG, "--->DisplayUtil--getWindowsSize1: x = " + x + ",y = " + y);
        Rect rect = new Rect();
        defaultDisplay.getRectSize(rect);
        int left = rect.left;
        int top = rect.top;
        int right = rect.right;
        int bottom = rect.bottom;
        Logger.i(TAG, "--->DisplayUtil--getWindowsSize2: left = " + left + ",top = " + top + ",right = " + right + ",bottom = " + bottom);
        DisplayMetrics displayMetrics = new DisplayMetrics();
        defaultDisplay.getMetrics(displayMetrics);
        int widthPixels = displayMetrics.widthPixels;
        int heightPixels = displayMetrics.heightPixels;
        Logger.i(TAG, "--->DisplayUtil--getWindowsSize3: widthPixels = " + widthPixels + ",heightPixels = " + heightPixels);
        Point realSize = new Point();
        defaultDisplay.getRealSize(realSize);
        int x4 = realSize.x;
        int y4 = realSize.y;
        Logger.i(TAG, "--->DisplayUtil--getWindowsSize4: x = " + x4 + ",y = " + y4);
        DisplayMetrics realMetrics = new DisplayMetrics();
        defaultDisplay.getRealMetrics(realMetrics);
        int widthPixel = realMetrics.widthPixels;
        int heightPixel = realMetrics.heightPixels;
        Logger.i(TAG, "--->DisplayUtil--getWindowsSize5: widthPixel = " + widthPixel + ",heightPixel = " + heightPixel);
    }

    public static int getStatusBarHeight(Context context) {
        int height = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            height = context.getResources().getDimensionPixelSize(resourceId);
        }
        return height;
    }

    public static void setDisplayFullScreen(Activity activity) {
        Window window = activity.getWindow();
        Resources resources = activity.getResources();
        if (Build.VERSION.SDK_INT >= 21) {
            window.getDecorView().setSystemUiVisibility(8192);
            window.setStatusBarColor(0);
        } else {
            window.getDecorView().setSystemUiVisibility(8192);
            window.addFlags(0x4000000);
        }
    }
}

