/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.util.Objects;

public class FileUtil {
    private final String TAG = "FileUtil";
    private String CACHE_ROOT_PATH;
    private String CACHE_IMAGE_PATH;
    private String CACHE_FILE_PATH;
    private String FILE_ROOT_PATH;
    private String FILE_ACCOUNT_PATH;
    private String FILE_IMAGE_PATH;
    private String FILE_AUDIO_PATH;
    private String FILE_VIDEO_PATH;
    private static volatile FileUtil instance;

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FileUtil getInstance() {
        if (instance != null) return instance;
        Class<FileUtil> clazz = FileUtil.class;
        synchronized (FileUtil.class) {
            if (instance != null) return instance;
            instance = new FileUtil();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void createDirsNotExist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            Log.i((String)"FileUtil", (String)"createDirsNotExist: path is null");
            return;
        }
        File file = new File(path);
        if (!file.exists()) {
            boolean b = file.mkdirs();
            Log.i((String)"FileUtil", (String)("createDirsNotExist: " + b + "; " + path));
        }
    }

    public String getCacheRootPath(Context context) {
        if (context != null && context.getExternalCacheDir() != null) {
            this.CACHE_ROOT_PATH = context.getExternalCacheDir().getAbsolutePath();
        }
        return this.CACHE_ROOT_PATH;
    }

    public String getCacheImagePath(Context context) {
        if (context != null && !TextUtils.isEmpty((CharSequence)this.getCacheRootPath(context))) {
            this.CACHE_IMAGE_PATH = this.getCacheRootPath(context) + "/image/";
        }
        this.createDirsNotExist(this.CACHE_IMAGE_PATH);
        return this.CACHE_IMAGE_PATH;
    }

    public String getCacheFilePath(Context context) {
        if (context != null && !TextUtils.isEmpty((CharSequence)this.getCacheRootPath(context))) {
            this.CACHE_FILE_PATH = this.getCacheRootPath(context) + "/file/";
        }
        this.createDirsNotExist(this.CACHE_FILE_PATH);
        return this.CACHE_FILE_PATH;
    }

    public String getFileRootPath(Context context) {
        if (context != null && context.getExternalFilesDir(null) != null) {
            this.FILE_ROOT_PATH = Objects.requireNonNull(context.getExternalFilesDir(null)).getAbsolutePath();
        }
        return this.FILE_ROOT_PATH;
    }

    public String getFileAccountPath(Context context, String account) {
        if (context != null && !TextUtils.isEmpty((CharSequence)this.getFileRootPath(context))) {
            this.FILE_ACCOUNT_PATH = this.getFileRootPath(context) + "/" + account + "/";
        }
        this.createDirsNotExist(this.FILE_ACCOUNT_PATH);
        return this.FILE_ACCOUNT_PATH;
    }

    public String getFileImagePath(Context context) {
        if (context != null && !TextUtils.isEmpty((CharSequence)this.getFileRootPath(context))) {
            this.FILE_IMAGE_PATH = this.getFileRootPath(context) + "/image/";
        }
        this.createDirsNotExist(this.FILE_IMAGE_PATH);
        return this.FILE_IMAGE_PATH;
    }

    public String getFileAudioPath(Context context) {
        if (context != null && !TextUtils.isEmpty((CharSequence)this.getFileRootPath(context))) {
            this.FILE_AUDIO_PATH = this.getFileRootPath(context) + "/audio/";
        }
        this.createDirsNotExist(this.FILE_AUDIO_PATH);
        return this.FILE_AUDIO_PATH;
    }

    public String getFileVideoPath(Context context) {
        if (context != null && !TextUtils.isEmpty((CharSequence)this.getFileRootPath(context))) {
            this.FILE_VIDEO_PATH = this.getFileRootPath(context) + "/video/";
        }
        this.createDirsNotExist(this.FILE_VIDEO_PATH);
        return this.FILE_VIDEO_PATH;
    }
}

