/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class GsonUtil {
    public static final String EMPTY = "";
    public static final String EMPTY_JSON = "{}";
    public static final String EMPTY_JSON_ARRAY = "[]";
    public static final String DEFAULT_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss";

    public static String toJson(Object target, Type targetType, boolean isSerializeNulls, Double version, String datePattern, boolean excludesFieldsWithoutExpose) {
        if (target == null) {
            return EMPTY_JSON;
        }
        GsonBuilder builder = new GsonBuilder();
        if (isSerializeNulls) {
            builder.serializeNulls();
        }
        if (version != null) {
            builder.setVersion(version.doubleValue());
        }
        if (GsonUtil.isEmpty(datePattern)) {
            datePattern = DEFAULT_DATE_PATTERN;
        }
        if (excludesFieldsWithoutExpose) {
            builder.excludeFieldsWithoutExposeAnnotation();
        }
        String result = EMPTY;
        Gson gson = builder.create();
        try {
            result = targetType != null ? gson.toJson(target, targetType) : gson.toJson(target);
        }
        catch (Exception ex) {
            result = target instanceof Collection || target instanceof Iterator || target instanceof Enumeration || target.getClass().isArray() ? EMPTY_JSON_ARRAY : EMPTY_JSON;
        }
        return result;
    }

    public static String toJson(Object target) {
        String jsonStr = GsonUtil.toJson(target, null, false, null, DEFAULT_DATE_PATTERN, false);
        if (EMPTY_JSON.equals(jsonStr)) {
            jsonStr = null;
        }
        return jsonStr;
    }

    public static String toJson(Object target, String datePattern) {
        return GsonUtil.toJson(target, null, false, null, datePattern, true);
    }

    public static String toJson(Object target, Double version) {
        return GsonUtil.toJson(target, null, false, version, null, true);
    }

    public static String toJson(Object target, boolean excludesFieldsWithoutExpose) {
        return GsonUtil.toJson(target, null, false, null, null, excludesFieldsWithoutExpose);
    }

    public static String toJson(Object target, Double version, boolean excludesFieldsWithoutExpose) {
        return GsonUtil.toJson(target, null, false, version, null, excludesFieldsWithoutExpose);
    }

    public static String toJson(Object target, Type targetType) {
        return GsonUtil.toJson(target, targetType, false, null, null, true);
    }

    public static String toJson(Object target, Type targetType, Double version) {
        return GsonUtil.toJson(target, targetType, false, version, null, true);
    }

    public static String toJson(Object target, Type targetType, boolean excludesFieldsWithoutExpose) {
        return GsonUtil.toJson(target, targetType, false, null, null, excludesFieldsWithoutExpose);
    }

    public static String toJson(Object target, Type targetType, Double version, boolean excludesFieldsWithoutExpose) {
        return GsonUtil.toJson(target, targetType, false, version, null, excludesFieldsWithoutExpose);
    }

    public static <T> T fromJson(String json, TypeToken<T> token) {
        if (GsonUtil.isEmpty(json)) {
            return null;
        }
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (Object)new IntegerDefaultAdapter());
        builder.registerTypeAdapter(String.class, (Object)new StringDefaultAdapter());
        Gson gson = builder.create();
        try {
            return (T)gson.fromJson(json, token.getType());
        }
        catch (Exception ex) {
            Log.e((String)"GsonUtil", (String)(json + " \u65e0\u6cd5\u8f6c\u6362\u4e3a " + token.getRawType().getName() + " \u5bf9\u8c61!"), (Throwable)ex);
            return null;
        }
    }

    @NotNull
    public static <T> T fromJsonKotlin(@NotNull String json, @NotNull TypeToken<T> token) {
        if (GsonUtil.isEmpty(json)) {
            return null;
        }
        GsonBuilder builder = new GsonBuilder();
        Gson gson = builder.create();
        try {
            return (T)gson.fromJson(json, token.getType());
        }
        catch (Exception ex) {
            Log.e((String)"GsonUtil", (String)(json + " \u65e0\u6cd5\u8f6c\u6362\u4e3a " + token.getRawType().getName() + " \u5bf9\u8c61!"), (Throwable)ex);
            return null;
        }
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        if (GsonUtil.isEmpty(json)) {
            return null;
        }
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(Integer.class, (Object)new IntegerDefaultAdapter());
        builder.registerTypeAdapter(String.class, (Object)new StringDefaultAdapter());
        Gson gson = builder.create();
        try {
            return (T)gson.fromJson(json, clazz);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean isEmpty(String inStr) {
        boolean reTag = false;
        if (inStr == null || EMPTY.equals(inStr) || "\"null\"".equals(inStr)) {
            reTag = true;
        }
        return reTag;
    }

    public static class IntegerDefaultAdapter
    extends TypeAdapter<Integer> {
        public void write(JsonWriter jsonWriter, Integer integer) throws IOException {
            jsonWriter.value(String.valueOf(integer));
        }

        public Integer read(JsonReader jsonReader) throws IOException {
            try {
                return Integer.valueOf(jsonReader.nextString());
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
                return -1;
            }
        }
    }

    public static class StringDefaultAdapter
    extends TypeAdapter<String> {
        public void write(JsonWriter jsonWriter, String s) throws IOException {
            jsonWriter.value(s);
        }

        public String read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return GsonUtil.EMPTY;
            }
            return jsonReader.nextString();
        }
    }
}

