/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import androidx.core.content.ContextCompat;
import java.lang.reflect.Method;

public class IMEIUtil {
    public static String getIMEI(Context context) {
        TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
        String deviceId = "";
        if (Build.VERSION.SDK_INT < 29) {
            if (Build.VERSION.SDK_INT >= 26) {
                deviceId = telephonyManager.getDeviceId();
            } else if (Build.VERSION.SDK_INT >= 23) {
                deviceId = telephonyManager.getDeviceId();
            }
        }
        if (TextUtils.isEmpty((CharSequence)deviceId)) {
            deviceId = Settings.System.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        }
        return deviceId;
    }

    public static String getIMEI1(Context context) {
        return IMEIUtil.getImeiOrMeid(context, 0);
    }

    public static String getIMEI2(Context context) {
        String imeiDefault = IMEIUtil.getIMEI1(context);
        if (TextUtils.isEmpty((CharSequence)imeiDefault)) {
            return "";
        }
        String imei1 = IMEIUtil.getImeiOrMeid(context, 0);
        String imei2 = IMEIUtil.getImeiOrMeid(context, 1);
        if (!TextUtils.equals((CharSequence)imei2, (CharSequence)imeiDefault)) {
            return imei2;
        }
        if (!TextUtils.equals((CharSequence)imei1, (CharSequence)imeiDefault)) {
            return imei1;
        }
        return "";
    }

    public static String getImeiOrMeid(Context context, int slotId) {
        String imei = "";
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return imei;
        }
        try {
            TelephonyManager manager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            if (manager != null) {
                if (Build.VERSION.SDK_INT >= 26) {
                    Method method = manager.getClass().getMethod("getImei", Integer.TYPE);
                    imei = (String)method.invoke((Object)manager, slotId);
                } else if (Build.VERSION.SDK_INT >= 21) {
                    imei = IMEIUtil.getSystemPropertyByReflect("ril.gsm.imei");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (TextUtils.isEmpty((CharSequence)imei)) {
            imei = IMEIUtil.getDeviceId(context, slotId);
        }
        return imei;
    }

    public static String getImeiOnly(Context context, int slotId) {
        String imeiOrMeid;
        String imei = "";
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return imei;
        }
        try {
            TelephonyManager manager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            if (manager != null) {
                if (Build.VERSION.SDK_INT >= 26) {
                    Method method = manager.getClass().getMethod("getImei", Integer.TYPE);
                    imei = (String)method.invoke((Object)manager, slotId);
                } else if (Build.VERSION.SDK_INT >= 21) {
                    imei = IMEIUtil.getSystemPropertyByReflect("ril.gsm.imei");
                }
            }
        }
        catch (Exception manager) {
            // empty catch block
        }
        if (TextUtils.isEmpty((CharSequence)imei) && !TextUtils.isEmpty((CharSequence)(imeiOrMeid = IMEIUtil.getDeviceId(context, slotId))) && imeiOrMeid.length() >= 15) {
            imei = imeiOrMeid;
        }
        return imei;
    }

    public static String getMeidOnly(Context context, int slotId) {
        String imeiOrMeid;
        String meid = "";
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return meid;
        }
        try {
            TelephonyManager manager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            if (manager != null) {
                if (Build.VERSION.SDK_INT >= 26) {
                    Method method = manager.getClass().getMethod("getMeid", Integer.TYPE);
                    meid = (String)method.invoke((Object)manager, slotId);
                } else if (Build.VERSION.SDK_INT >= 21) {
                    meid = IMEIUtil.getSystemPropertyByReflect("ril.cdma.meid");
                }
            }
        }
        catch (Exception manager) {
            // empty catch block
        }
        if (TextUtils.isEmpty((CharSequence)meid) && (imeiOrMeid = IMEIUtil.getDeviceId(context, slotId)).length() == 14) {
            meid = imeiOrMeid;
        }
        return meid;
    }

    private static String getSystemPropertyByReflect(String key) {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method getMethod = clz.getMethod("get", String.class, String.class);
            return (String)getMethod.invoke(clz, key, "");
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getDeviceId(Context context) {
        String imei = "";
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return imei;
        }
        imei = IMEIUtil.getDeviceIdFromSystemApi(context);
        if (TextUtils.isEmpty((CharSequence)imei)) {
            imei = IMEIUtil.getDeviceIdByReflect(context);
        }
        return imei;
    }

    public static String getDeviceId(Context context, int slotId) {
        String imei = "";
        imei = IMEIUtil.getDeviceIdFromSystemApi(context, slotId);
        if (TextUtils.isEmpty((CharSequence)imei)) {
            imei = IMEIUtil.getDeviceIdByReflect(context, slotId);
        }
        return imei;
    }

    public static String getDeviceIdFromSystemApi(Context context, int slotId) {
        String imei = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            if (telephonyManager != null && Build.VERSION.SDK_INT >= 23) {
                imei = telephonyManager.getDeviceId(slotId);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return imei;
    }

    public static String getDeviceIdFromSystemApi(Context context) {
        String imei = "";
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            if (telephonyManager != null) {
                imei = telephonyManager.getDeviceId();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return imei;
    }

    public static String getDeviceIdByReflect(Context context) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            if (Build.VERSION.SDK_INT >= 21) {
                Method simMethod = TelephonyManager.class.getDeclaredMethod("getDefaultSim", new Class[0]);
                Object sim = simMethod.invoke((Object)tm, new Object[0]);
                Method method = TelephonyManager.class.getDeclaredMethod("getDeviceId", Integer.TYPE);
                return method.invoke((Object)tm, sim).toString();
            }
            Class<?> clazz = Class.forName("com.android.internal.telephony.IPhoneSubInfo");
            Method subInfoMethod = TelephonyManager.class.getDeclaredMethod("getSubscriberInfo", new Class[0]);
            subInfoMethod.setAccessible(true);
            Object subInfo = subInfoMethod.invoke((Object)tm, new Object[0]);
            Method method = clazz.getDeclaredMethod("getDeviceId", new Class[0]);
            return method.invoke(subInfo, new Object[0]).toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getDeviceIdByReflect(Context context, int slotId) {
        try {
            TelephonyManager tm = (TelephonyManager)context.getApplicationContext().getSystemService("phone");
            Method method = tm.getClass().getMethod("getDeviceId", Integer.TYPE);
            return method.invoke((Object)tm, slotId).toString();
        }
        catch (Throwable throwable) {
            return "";
        }
    }
}

