/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ImageUtil {
    public static Bitmap drawRectangles(Bitmap bitmap, int[] rect) {
        Bitmap mutableBitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        Canvas canvas = new Canvas(mutableBitmap);
        Paint paint = new Paint();
        int left = rect[0];
        int top = rect[1];
        int right = rect[2];
        int bottom = rect[3];
        paint.setColor(-65536);
        paint.setStyle(Paint.Style.STROKE);
        paint.setStrokeWidth(2.0f);
        canvas.drawRect((float)left, (float)top, (float)right, (float)bottom, paint);
        return mutableBitmap;
    }

    public static void saveBitmap(Bitmap bitmap, String path) {
        File filePic;
        if (!Environment.getExternalStorageState().equals("mounted")) {
            Log.e((String)"tag", (String)"saveBitmap failure : sdcard not mounted");
            return;
        }
        String savePath = path;
        try {
            filePic = new File(savePath);
            if (!filePic.exists()) {
                filePic.getParentFile().mkdirs();
                filePic.createNewFile();
            }
            FileOutputStream fos = new FileOutputStream(filePic);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
            fos.flush();
            fos.close();
        }
        catch (IOException e) {
            Log.e((String)"tag", (String)("saveBitmap: " + e.getMessage()));
            return;
        }
        Log.i((String)"tag", (String)("saveBitmap success: " + filePic.getAbsolutePath()));
    }
}

