/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import com.bfcy.base.log.Logger;
import com.bfcy.base.utils.LanguageType;
import com.bfcy.base.utils.SPUtil;
import java.util.Locale;

public class LanguageUtil {
    private static final String TAG = "LanguageUtil";

    public static void changeAppLanguage(Context context, String newLanguage) {
        if (TextUtils.isEmpty((CharSequence)newLanguage)) {
            return;
        }
        Resources resources = context.getResources();
        Configuration configuration = resources.getConfiguration();
        Locale locale = LanguageUtil.getLocaleByLanguage(newLanguage);
        configuration.setLocale(locale);
        DisplayMetrics dm = resources.getDisplayMetrics();
        resources.updateConfiguration(configuration, dm);
    }

    public static Locale getLocaleByLanguage(String language) {
        Locale locale = Locale.SIMPLIFIED_CHINESE;
        if (language.equals(LanguageType.CHINESE.getLanguage())) {
            locale = Locale.SIMPLIFIED_CHINESE;
        } else if (language.equals(LanguageType.ENGLISH.getLanguage())) {
            locale = Locale.ENGLISH;
        } else if (language.equals(LanguageType.THAILAND.getLanguage())) {
            locale = Locale.forLanguageTag(language);
        }
        Log.d((String)TAG, (String)("getLocaleByLanguage: " + locale.getDisplayName()));
        return locale;
    }

    public static Context attachBaseContext(Context context, String language) {
        Log.d((String)TAG, (String)("attachBaseContext: " + Build.VERSION.SDK_INT));
        if ("".equals(language)) {
            String systemLanguage = SPUtil.getInstance(context).getString("system_language");
            Logger.i("tag", "systemLanguage2\uff1a" + systemLanguage);
            return LanguageUtil.updateResources(context, systemLanguage);
        }
        if (Build.VERSION.SDK_INT >= 24) {
            return LanguageUtil.updateResources(context, language);
        }
        return context;
    }

    @TargetApi(value=24)
    private static Context updateResources(Context context, String language) {
        Resources resources = context.getResources();
        Locale locale = LanguageUtil.getLocaleByLanguage(language);
        Configuration configuration = resources.getConfiguration();
        configuration.setLocale(locale);
        configuration.setLocales(new LocaleList(new Locale[]{locale}));
        return context.createConfigurationContext(configuration);
    }
}

