/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.os.Parcelable;
import com.tencent.mmkv.MMKV;
import java.util.Set;

public class MMKVUtil {
    public static MMKV mmkv = MMKV.defaultMMKV();
    private static final String USER_INFO = "key_user_info_json";

    public static void setUserInfo(String userJson) {
        mmkv.encode(USER_INFO, userJson);
    }

    public static String getUserInfo() {
        return mmkv.decodeString(USER_INFO);
    }

    public static void clearUserInfo() {
        mmkv.removeValueForKey(USER_INFO);
    }

    public static void encode(String key, Object object) {
        if (object instanceof String) {
            mmkv.encode(key, (String)object);
        } else if (object instanceof Integer) {
            mmkv.encode(key, ((Integer)object).intValue());
        } else if (object instanceof Boolean) {
            mmkv.encode(key, ((Boolean)object).booleanValue());
        } else if (object instanceof Float) {
            mmkv.encode(key, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            mmkv.encode(key, ((Long)object).longValue());
        } else if (object instanceof Double) {
            mmkv.encode(key, ((Double)object).doubleValue());
        } else if (object instanceof byte[]) {
            mmkv.encode(key, (byte[])object);
        } else {
            mmkv.encode(key, object.toString());
        }
    }

    public static void encode(String key, int value) {
        mmkv.encode(key, value);
    }

    public static void encode(String key, long value) {
        mmkv.encode(key, value);
    }

    public static void encode(String key, float value) {
        mmkv.encode(key, value);
    }

    public static void encode(String key, double value) {
        mmkv.encode(key, value);
    }

    public static void encode(String key, String value) {
        mmkv.encode(key, value);
    }

    public static void encode(String key, boolean value) {
        mmkv.encode(key, value);
    }

    public static void encode(String key, byte[] value) {
        mmkv.encode(key, value);
    }

    public static void encode(String key, Parcelable value) {
        mmkv.encode(key, value);
    }

    public static void encode(String key, Set<String> value) {
        mmkv.encode(key, value);
    }

    public static int decodeInt(String key) {
        return mmkv.decodeInt(key);
    }

    public static int decodeInt(String key, int defaultValue) {
        return mmkv.decodeInt(key, defaultValue);
    }

    public static long decodeLong(String key) {
        return mmkv.decodeLong(key);
    }

    public static long decodeLong(String key, long defaultValue) {
        return mmkv.decodeLong(key, defaultValue);
    }

    public static float decodeFloat(String key) {
        return mmkv.decodeFloat(key);
    }

    public static float decodeFloat(String key, int defaultValue) {
        return mmkv.decodeFloat(key, (float)defaultValue);
    }

    public static double decodeDouble(String key) {
        return mmkv.decodeDouble(key);
    }

    public static double decodeDouble(String key, double defaultValue) {
        return mmkv.decodeDouble(key, defaultValue);
    }

    public static String decodeString(String key) {
        return mmkv.decodeString(key);
    }

    public static String decodeString(String key, String defaultValue) {
        return mmkv.decodeString(key, defaultValue);
    }

    public static boolean decodeBool(String key) {
        return mmkv.decodeBool(key);
    }

    public static boolean decodeBool(String key, boolean defaultValue) {
        return mmkv.decodeBool(key, defaultValue);
    }

    public static byte[] decodeBytes(String key) {
        return mmkv.decodeBytes(key);
    }

    public static byte[] decodeBytes(String key, byte[] defaultValue) {
        return mmkv.decodeBytes(key, defaultValue);
    }

    public static <T extends Parcelable> T decodeParcelable(String key, Class<T> tClass) {
        return (T)mmkv.decodeParcelable(key, tClass);
    }

    public static <T extends Parcelable> T decodeParcelable(String key, Class<T> tClass, T defaultValue) {
        return (T)mmkv.decodeParcelable(key, tClass, defaultValue);
    }

    public static Set<String> decodeStringSet(String key) {
        return mmkv.decodeStringSet(key);
    }

    public static Set<String> decodeStringSet(String key, Set<String> defaultValue) {
        return mmkv.decodeStringSet(key, defaultValue);
    }

    public static Set<String> decodeStringSet(String key, Set<String> defaultValue, Class<? extends Set> cls) {
        return mmkv.decodeStringSet(key, defaultValue, cls);
    }
}

