/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class ReadWriteUtils {
    public static String getAssetsFile(Context context, String fileName) {
        InputStream is = null;
        String result = null;
        try {
            is = context.getAssets().open(fileName);
            int length = is.available();
            byte[] buffer = new byte[length];
            is.read(buffer);
            result = new String(buffer, StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Bitmap getAssetsImage(Context context, String fileName) {
        Bitmap bitmap = null;
        AssetManager assetManager = context.getAssets();
        try {
            InputStream inputStream = assetManager.open(fileName);
            bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bitmap;
    }

    public static String txt2String(String filePath) {
        File file = new File(filePath);
        return ReadWriteUtils.txt2String(file);
    }

    public static String txt2String(File file) {
        StringBuilder result = new StringBuilder();
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String s = null;
            while ((s = br.readLine()) != null) {
                result.append(System.lineSeparator() + s);
            }
            br.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    public static void string2Text(String content) throws IOException {
        String state = Environment.getExternalStorageState();
        if (state.equals("mounted")) {
            File SDPath = Environment.getExternalStorageDirectory();
            File file = new File(SDPath, "data.txt");
            FileWriter writer = new FileWriter(file, true);
            writer.write(content);
            writer.close();
        }
    }

    public static void string2Text(File file, String content) throws IOException {
        FileWriter writer = new FileWriter(file, true);
        writer.write(content);
        writer.close();
    }
}

