/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Properties;

public class RomUtil {
    private static final String TAG = "Rom";
    public static final String ROM_MIUI = "MIUI";
    public static final String ROM_EMUI = "EMUI";
    public static final String ROM_FLYME = "FLYME";
    public static final String ROM_OPPO = "OPPO";
    public static final String ROM_SMARTISAN = "SMARTISAN";
    public static final String ROM_VIVO = "VIVO";
    public static final String ROM_QIKU = "QIKU";
    private static final String KEY_VERSION_MIUI = "ro.miui.ui.version.name";
    private static final String KEY_VERSION_EMUI = "ro.build.version.emui";
    private static final String KEY_VERSION_OPPO = "ro.build.version.opporom";
    private static final String KEY_VERSION_SMARTISAN = "ro.smartisan.version";
    private static final String KEY_VERSION_VIVO = "ro.vivo.os.version";
    private static String sName;
    private static String sVersion;
    private static final String KEY_MIUI_VERSION_CODE = "ro.miui.ui.version.code";

    public static boolean isEmui() {
        return RomUtil.check(ROM_EMUI);
    }

    public static boolean isMiui() {
        return RomUtil.check(ROM_MIUI);
    }

    public static boolean isVivo() {
        return RomUtil.check(ROM_VIVO);
    }

    public static boolean isOppo() {
        return RomUtil.check(ROM_OPPO);
    }

    public static boolean isFlyme() {
        return RomUtil.check(ROM_FLYME);
    }

    public static boolean is360() {
        return RomUtil.check(ROM_QIKU) || RomUtil.check("360");
    }

    public static boolean isSmartisan() {
        return RomUtil.check(ROM_SMARTISAN);
    }

    public static String getName() {
        if (sName == null) {
            RomUtil.check("");
        }
        return sName;
    }

    public static String getVersion() {
        if (sVersion == null) {
            RomUtil.check("");
        }
        return sVersion;
    }

    public static boolean check(String rom) {
        if (sName != null) {
            return sName.equals(rom);
        }
        sVersion = RomUtil.getProp(KEY_VERSION_MIUI);
        if (!TextUtils.isEmpty((CharSequence)sVersion)) {
            sName = ROM_MIUI;
        } else {
            sVersion = RomUtil.getProp(KEY_VERSION_EMUI);
            if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                sName = ROM_EMUI;
            } else {
                sVersion = RomUtil.getProp(KEY_VERSION_OPPO);
                if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                    sName = ROM_OPPO;
                } else {
                    sVersion = RomUtil.getProp(KEY_VERSION_VIVO);
                    if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                        sName = ROM_VIVO;
                    } else {
                        sVersion = RomUtil.getProp(KEY_VERSION_SMARTISAN);
                        if (!TextUtils.isEmpty((CharSequence)sVersion)) {
                            sName = ROM_SMARTISAN;
                        } else {
                            sVersion = Build.DISPLAY;
                            if (sVersion.toUpperCase().contains(ROM_FLYME)) {
                                sName = ROM_FLYME;
                            } else {
                                sVersion = "unknown";
                                sName = Build.MANUFACTURER.toUpperCase();
                            }
                        }
                    }
                }
            }
        }
        return sName.equals(rom);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProp(String name) {
        String line = null;
        BufferedReader input = null;
        try {
            Process p = Runtime.getRuntime().exec("getprop " + name);
            input = new BufferedReader(new InputStreamReader(p.getInputStream()), 1024);
            line = input.readLine();
            input.close();
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)("Unable to read prop " + name), (Throwable)ex);
            String string = null;
            return string;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return line;
    }

    private static boolean isFlymeV4OrAbove() {
        String displayId = Build.DISPLAY;
        if (!TextUtils.isEmpty((CharSequence)displayId) && displayId.contains("Flyme")) {
            String[] displayIdArray;
            for (String temp : displayIdArray = displayId.split(" ")) {
                if (!temp.matches("^[4-9]\\.(\\d+\\.)+\\S*")) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isAndroidMOrAbove() {
        return Build.VERSION.SDK_INT >= 23;
    }

    private static boolean isMiUIV6OrAbove() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
            String uiCode = properties.getProperty(KEY_MIUI_VERSION_CODE, null);
            if (uiCode != null) {
                int code = Integer.parseInt(uiCode);
                return code >= 4;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean isMiUIV7OrAbove() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream(new File(Environment.getRootDirectory(), "build.prop")));
            String uiCode = properties.getProperty(KEY_MIUI_VERSION_CODE, null);
            if (uiCode != null) {
                int code = Integer.parseInt(uiCode);
                return code >= 5;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

