/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.content.Context;
import android.content.SharedPreferences;

public class SPUtil {
    private static final String SP_NAME = "base_sp";
    private static SPUtil spUtil;
    private static SharedPreferences baseSP;

    private SPUtil(Context context) {
        baseSP = context.getSharedPreferences(SP_NAME, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SPUtil getInstance(Context context) {
        if (spUtil != null) return spUtil;
        Class<SPUtil> clazz = SPUtil.class;
        synchronized (SPUtil.class) {
            if (spUtil != null) return spUtil;
            spUtil = new SPUtil(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return spUtil;
        }
    }

    public void setThemeType(int value) {
        baseSP.edit().putInt("theme_type", value).apply();
    }

    public int getThemeType(int defaultValue) {
        return baseSP.getInt("theme_type", defaultValue);
    }

    public void putString(String key, String value) {
        baseSP.edit().putString(key, value).apply();
    }

    public String getString(String key, String defaultValue) {
        return baseSP.getString(key, defaultValue);
    }

    public String getString(String key) {
        return baseSP.getString(key, "");
    }

    public void putBoolean(String key, boolean value) {
        baseSP.edit().putBoolean(key, value).apply();
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return baseSP.getBoolean(key, defaultValue);
    }

    public boolean getBoolean(String key) {
        return baseSP.getBoolean(key, false);
    }

    public void putInt(String key, int value) {
        baseSP.edit().putInt(key, value).apply();
    }

    public int getInt(String key, int defaultValue) {
        return baseSP.getInt(key, defaultValue);
    }

    public int getInt(String key) {
        return baseSP.getInt(key, 0);
    }
}

