/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.content.Context;
import android.content.SharedPreferences;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;

public class SPUtils {
    public static final String FILE_NAME = "sp_data";
    private static SPUtils spUtils;
    private static SharedPreferences sp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static SPUtils getInstance(Context context) {
        if (spUtils == null) {
            Class<SPUtils> clazz = SPUtils.class;
            // MONITORENTER : com.bfcy.base.utils.SPUtils.class
            if (spUtils == null) {
                spUtils = new SPUtils();
            }
            // MONITOREXIT : clazz
        }
        if (sp != null) return spUtils;
        sp = context.getSharedPreferences(FILE_NAME, 0);
        return spUtils;
    }

    public void put(String key, Object object) {
        SharedPreferences.Editor editor = sp.edit();
        if (object instanceof String) {
            editor.putString(key, (String)object);
        } else if (object instanceof Integer) {
            editor.putInt(key, ((Integer)object).intValue());
        } else if (object instanceof Boolean) {
            editor.putBoolean(key, ((Boolean)object).booleanValue());
        } else if (object instanceof Float) {
            editor.putFloat(key, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            editor.putLong(key, ((Long)object).longValue());
        } else {
            editor.putString(key, object.toString());
        }
        editor.apply();
    }

    public Object get(String key, Object defaultObject) {
        if (defaultObject instanceof String) {
            return sp.getString(key, (String)defaultObject);
        }
        if (defaultObject instanceof Integer) {
            return sp.getInt(key, ((Integer)defaultObject).intValue());
        }
        if (defaultObject instanceof Boolean) {
            return sp.getBoolean(key, ((Boolean)defaultObject).booleanValue());
        }
        if (defaultObject instanceof Float) {
            return Float.valueOf(sp.getFloat(key, ((Float)defaultObject).floatValue()));
        }
        if (defaultObject instanceof Long) {
            return sp.getLong(key, ((Long)defaultObject).longValue());
        }
        return null;
    }

    public static void put(Context context, String key, Object object) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = sp.edit();
        if (object instanceof String) {
            editor.putString(key, (String)object);
        } else if (object instanceof Integer) {
            editor.putInt(key, ((Integer)object).intValue());
        } else if (object instanceof Boolean) {
            editor.putBoolean(key, ((Boolean)object).booleanValue());
        } else if (object instanceof Float) {
            editor.putFloat(key, ((Float)object).floatValue());
        } else if (object instanceof Long) {
            editor.putLong(key, ((Long)object).longValue());
        } else {
            editor.putString(key, object.toString());
        }
        SharedPreferencesCompat.apply(editor);
    }

    public static Object get(Context context, String key, Object defaultObject) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, 0);
        if (defaultObject instanceof String) {
            return sp.getString(key, (String)defaultObject);
        }
        if (defaultObject instanceof Integer) {
            return sp.getInt(key, ((Integer)defaultObject).intValue());
        }
        if (defaultObject instanceof Boolean) {
            return sp.getBoolean(key, ((Boolean)defaultObject).booleanValue());
        }
        if (defaultObject instanceof Float) {
            return Float.valueOf(sp.getFloat(key, ((Float)defaultObject).floatValue()));
        }
        if (defaultObject instanceof Long) {
            return sp.getLong(key, ((Long)defaultObject).longValue());
        }
        return null;
    }

    public static void remove(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.remove(key);
        SharedPreferencesCompat.apply(editor);
    }

    public static void clear(Context context) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, 0);
        SharedPreferences.Editor editor = sp.edit();
        editor.clear();
        SharedPreferencesCompat.apply(editor);
    }

    public static boolean contains(Context context, String key) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, 0);
        return sp.contains(key);
    }

    public static Map<String, ?> getAll(Context context) {
        SharedPreferences sp = context.getSharedPreferences(FILE_NAME, 0);
        return sp.getAll();
    }

    private static class SharedPreferencesCompat {
        private static final Method sApplyMethod = SharedPreferencesCompat.findApplyMethod();

        private SharedPreferencesCompat() {
        }

        private static Method findApplyMethod() {
            try {
                Class<SharedPreferences.Editor> clz = SharedPreferences.Editor.class;
                return clz.getMethod("apply", new Class[0]);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
        }

        public static void apply(SharedPreferences.Editor editor) {
            try {
                if (sApplyMethod != null) {
                    sApplyMethod.invoke((Object)editor, new Object[0]);
                    return;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
            editor.commit();
        }
    }
}

