/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.text.TextUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StringUtils {
    public static final String reg = "^([a-z]|[A-Z]|[0-9]|[\u2e80-\u9fff]){3,}|@(?:[\\w](?:[\\w-]*[\\w])?\\.)+[\\w](?:[\\w-]*[\\w])?|[wap.]{4}|[www.]{4}|[blog.]{5}|[bbs.]{4}|[.com]{4}|[.cn]{3}|[.net]{4}|[.org]{4}|[http://]{7}|[ftp://]{6}$";
    public static final Pattern pattern = Pattern.compile("^([a-z]|[A-Z]|[0-9]|[\u2e80-\u9fff]){3,}|@(?:[\\w](?:[\\w-]*[\\w])?\\.)+[\\w](?:[\\w-]*[\\w])?|[wap.]{4}|[www.]{4}|[blog.]{5}|[bbs.]{4}|[.com]{4}|[.cn]{3}|[.net]{4}|[.org]{4}|[http://]{7}|[ftp://]{6}$");
    public static final String REGEX_PWD = "^(?![a-zA-Z]+$)(?!\\d+$)(?![\\W_]+$)\\S{8,16}$";

    public static boolean isNumeric(String str) {
        String regEx = "-?[0-9]+";
        Pattern pattern = Pattern.compile(regEx);
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean isPositiveNumber(String str) {
        String regEx = "^[0-9]+$";
        Pattern pattern = Pattern.compile(regEx);
        Matcher isNum = pattern.matcher(str);
        return isNum.matches();
    }

    public static boolean containsEmoji(String source) {
        if (source.isEmpty()) {
            return false;
        }
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (!StringUtils.isEmojiCharacter(codePoint)) continue;
            return true;
        }
        return false;
    }

    public static String filterEmoji(String source) {
        if (TextUtils.isEmpty((CharSequence)source)) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int len = source.length();
        for (int i = 0; i < len; ++i) {
            char codePoint = source.charAt(i);
            if (StringUtils.isEmojiCharacter(codePoint)) continue;
            stringBuilder.append(codePoint);
        }
        return stringBuilder.toString();
    }

    private static boolean isEmojiCharacter(char codePoint) {
        return !(codePoint == '\u0000' || codePoint == '\t' || codePoint == '\n' || codePoint == '\r' || codePoint >= ' ' && codePoint <= '\ud7ff' || codePoint >= '\ue000' && codePoint <= '\ufffd' || codePoint >= '\u10000' && codePoint <= '\u10ffff');
    }

    public static boolean isNormalString(String email) {
        String str = "^[A-Za-z0-9 \\u4e00-\\u9fa5._%+-]{1,20}$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean isMobileNOs(String mobiles) {
        String telRegex = "[1]\\d{10}";
        if (TextUtils.isEmpty((CharSequence)mobiles)) {
            return false;
        }
        return mobiles.matches(telRegex);
    }

    public static boolean isMobileNO(String mobiles) {
        String str = "^((13[0-9])|(15[^4,\\D])|(18[0,5-9]))\\d{8}$";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(mobiles);
        return m.matches();
    }

    public static boolean isEmail(String email) {
        String str = "[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\\.[A-Za-z]{2,6}";
        Pattern p = Pattern.compile(str);
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean checkPwd(String pwd) {
        if (!TextUtils.isEmpty((CharSequence)pwd)) {
            return pwd.matches(REGEX_PWD);
        }
        return false;
    }
}

