/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.os.Build;
import android.text.format.DateFormat;
import android.util.Log;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class TimeUtil {
    private static final String TAG = "TimeUtil";
    public static final String FORMAT_DATE = "yyyy-MM-dd";
    public static final String FORMAT_DATE_2 = "yyyy/MM/dd";
    public static final String FORMAT_DATE_3 = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String FORMAT_TIME = "HH:mm";
    public static final String FORMAT_TIME_SECOND = "HH:mm:ss";
    public static final String FORMAT_DATE_TIME = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_DATE_TIME_2 = "yyyy/MM/dd HH:mm";
    public static final String FORMAT_DATE_TIME_3 = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm";
    public static final String FORMAT_DATE_TIME_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String FORMAT_DATE_TIME_SECOND_2 = "yyyy/MM/dd HH:mm:ss";
    public static final String FORMAT_DATE_TIME_SECOND_3 = "yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss";
    private static final String FORMAT_DATE_TIME_MILLISECOND = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final String FORMAT_DATE_TIME_ZONE = "yyyy-MM-dd'T'hh:mm:ss.SSS'Z'";
    public static final String FORMAT_YEAR = "yyyy";
    public static final String FORMAT_MONTH_DAY = "MM\u6708dd\u65e5";
    public static final String FORMAT_MONTH_DAY_TIME = "MM\u6708dd\u65e5  hh:mm";
    public static final String FORMAT_DEFAULT = "yyyy-MM-dd HH:mm:ss";
    private static final int YEAR = 31536000;
    private static final int MONTH = 2592000;
    private static final int DAY = 86400;
    private static final int HOUR = 3600;
    private static final int MINUTE = 60;

    public static void testSimpleDateFormat() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        SimpleDateFormat sdf2 = new SimpleDateFormat();
        sdf.applyPattern("yyyy-MM-dd HH:mm:ss");
        sdf.applyLocalizedPattern("yyyy-MM-dd HH:mm:ss");
        String str = sdf.format(new Date());
    }

    public static String getDescriptionTimeFromTimestamp(long timestamp) {
        long currentTime = System.currentTimeMillis() / 1000L;
        long timeGap = currentTime - timestamp;
        System.out.println("timeGap: " + timeGap);
        String timeStr = timeGap > 31536000L ? timeGap / 31536000L + "\u5e74\u524d" : (timeGap > 2592000L ? timeGap / 2592000L + "\u4e2a\u6708\u524d" : (timeGap > 86400L ? timeGap / 86400L + "\u5929\u524d" : (timeGap > 3600L ? timeGap / 3600L + "\u5c0f\u65f6\u524d" : (timeGap > 60L ? timeGap / 60L + "\u5206\u949f\u524d" : "\u521a\u521a"))));
        return timeStr;
    }

    public static String getChatTime(long timestamp) {
        long clearTime = timestamp * 1000L;
        String result = "";
        SimpleDateFormat sdf = new SimpleDateFormat("dd");
        Date today = new Date(System.currentTimeMillis());
        Date otherDay = new Date(clearTime);
        int temp = Integer.parseInt(sdf.format(today)) - Integer.parseInt(sdf.format(otherDay));
        switch (temp) {
            case 0: {
                result = "\u4eca\u5929 " + TimeUtil.formatLongTime(clearTime, FORMAT_TIME);
                break;
            }
            case 1: {
                result = "\u6628\u5929 " + TimeUtil.formatLongTime(clearTime, FORMAT_TIME);
                break;
            }
            case 2: {
                result = "\u524d\u5929 " + TimeUtil.formatLongTime(clearTime, FORMAT_TIME);
                break;
            }
            default: {
                result = TimeUtil.formatLongTime(clearTime, "yyyy-MM-dd HH:mm:ss");
            }
        }
        return result;
    }

    public static boolean isSameDay(long time1, long time2) {
        String t1 = TimeUtil.formatLongTime(time1, FORMAT_DATE);
        String t2 = TimeUtil.formatLongTime(time2, FORMAT_DATE);
        return t1.equals(t2);
    }

    public static long getTodayZeroPointTimestamps() {
        long currentTimestamps = System.currentTimeMillis();
        long oneDayMillis = 86400000L;
        long zeroToCurrentMillis = (currentTimestamps + (long)TimeZone.getDefault().getRawOffset()) % oneDayMillis;
        return currentTimestamps - zeroToCurrentMillis;
    }

    public static String formatCurrentTime(String formatType) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatType, Locale.CHINA);
        return sdf.format(new Date());
    }

    public static String formatCurrentTime() {
        return TimeUtil.formatCurrentTime("yyyy-MM-dd HH:mm:ss");
    }

    public static String formatDateTime(Date data, String formatType) {
        SimpleDateFormat sdf = new SimpleDateFormat(formatType, Locale.CHINA);
        return sdf.format(data);
    }

    public static String formatLongTime(long timestamp, String formatType) {
        Date date = new Date(timestamp);
        return TimeUtil.formatDateTime(date, formatType);
    }

    public static String formatUtcTime(Long millisecond) {
        Calendar cal = Calendar.getInstance(Locale.CHINA);
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        Date nowTime = new Date(millisecond - (long)(zoneOffset + dstOffset));
        SimpleDateFormat sdf = new SimpleDateFormat(FORMAT_DATE_TIME_ZONE, Locale.CHINA);
        return sdf.format(nowTime);
    }

    public static CharSequence getUTCTime1() {
        Calendar cal = Calendar.getInstance(Locale.CHINA);
        int zoneOffset = cal.get(15);
        int dstOffset = cal.get(16);
        cal.add(14, -(zoneOffset + dstOffset));
        return DateFormat.format((CharSequence)FORMAT_DATE_TIME_ZONE, (Calendar)cal);
    }

    public static CharSequence getUTCTime2() {
        if (Build.VERSION.SDK_INT >= 26) {
            ZonedDateTime zonedDateTime = ZonedDateTime.now(ZoneOffset.UTC);
            return zonedDateTime.toString();
        }
        return TimeUtil.formatUtcTime(System.currentTimeMillis());
    }

    public static CharSequence getUTCTime3() {
        if (Build.VERSION.SDK_INT >= 26) {
            LocalDateTime localDateTime = LocalDateTime.now(ZoneOffset.UTC);
            return localDateTime.toString();
        }
        return TimeUtil.formatUtcTime(System.currentTimeMillis());
    }

    public static LocalDateTime getLocalDateTimeInUTC() {
        if (Build.VERSION.SDK_INT >= 26) {
            ZonedDateTime nowUTC = ZonedDateTime.now(ZoneOffset.UTC);
            return nowUTC.toLocalDateTime();
        }
        return null;
    }

    public static String formatMediaTime(int milliseconds) {
        if (milliseconds < 0) {
            return "00:00";
        }
        int hour = milliseconds / 1000 / 60 / 60;
        int minute = (milliseconds - hour * 60 * 60 * 1000) / 1000 / 60;
        int second = milliseconds / 1000 % 60;
        String h = hour < 10 ? "0" + hour : "" + hour;
        String m = minute < 10 ? "0" + minute : "" + minute;
        String s = second < 10 ? "0" + second : "" + second;
        if (hour > 0) {
            return h + ":" + m + ":" + s;
        }
        return m + ":" + s;
    }

    public static void logTimeZone() {
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--UTC-Time: " + TimeUtil.formatUtcTime(System.currentTimeMillis())));
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--UTC-Time1: " + TimeUtil.getUTCTime1()));
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--UTC-Time2: " + TimeUtil.getUTCTime2()));
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--UTC-Time3: " + TimeUtil.getUTCTime3()));
        TimeZone timeZone = TimeZone.getDefault();
        int rawOffset = timeZone.getRawOffset();
        int dstSavings = timeZone.getDSTSavings();
        String region = timeZone.getID();
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--rawOffset: " + rawOffset));
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--dstSavings: " + dstSavings));
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--region: " + region));
        String displayName1 = timeZone.getDisplayName(false, 0);
        String displayName2 = timeZone.getDisplayName(true, 0);
        String displayName3 = timeZone.getDisplayName(false, 1);
        String displayName4 = timeZone.getDisplayName(true, 1);
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--displayName1: " + displayName1));
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--displayName2: " + displayName2));
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--displayName3: " + displayName3));
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--displayName4: " + displayName4));
        int offset = timeZone.getRawOffset();
        int offsetsec = offset / 1000;
        String formatstr = "UTC%d:%d";
        String timezone = String.format(Locale.CHINA, formatstr, offsetsec / 3600, offset % 60);
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--timezone: " + timezone));
        Calendar curCalendar = Calendar.getInstance();
        Date curDate = new Date();
        curCalendar.setTime(curDate);
        int curDstOffset = curCalendar.get(16);
        Log.i((String)TAG, (String)("LocalInfo--TimeZone--Calendar--curDstOffset: " + curDstOffset));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
        Date date = null;
        try {
            date = dateFormat.parse("2021-04-01 00:00:00");
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        Calendar specifyCalendar = Calendar.getInstance();
        if (date != null) {
            specifyCalendar.setTime(date);
            int specifyDstOffset = specifyCalendar.get(16);
            Log.i((String)TAG, (String)("LocalInfo--TimeZone--Calendar--specifyDstOffset: " + specifyDstOffset));
        }
    }
}

