/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bfcy.base.R;
import com.bfcy.base.utils.ThemeUtil;

public class TitleBarUtil {
    public static final boolean titleDefaultLightMode = false;
    public static final int defaultBackStyle = 1;
    public static final int defaultDeleteStyle = 1;
    public static final int defaultSearchStyle = 1;
    public static final int defaultSettingsStyle = 1;
    public static final int defaultMoreStyle = 1;

    public static void initTitleBar(Context context, boolean isLight, int titleBarColor, View layoutTitleBar, ImageView ivBack, ImageView ivDelete, TextView tvStartTitle, TextView tvBackStartTitle, TextView tvTitle, TextView tvRightText) {
        if (isLight) {
            if (titleBarColor != 0) {
                layoutTitleBar.setBackgroundColor(titleBarColor);
            } else {
                layoutTitleBar.setBackgroundColor(ThemeUtil.getThemeColor(context, R.attr.themeColorTitleBarLight));
            }
            tvStartTitle.setTextColor(ThemeUtil.getThemeColor(context, R.attr.themeColorFontTitleLight));
            tvBackStartTitle.setTextColor(ThemeUtil.getThemeColor(context, R.attr.themeColorFontTitleLight));
            tvTitle.setTextColor(ThemeUtil.getThemeColor(context, R.attr.themeColorFontTitleLight));
            tvRightText.setTextColor(ThemeUtil.getThemeColor(context, R.attr.themeColorFontTitleLight));
        } else {
            if (titleBarColor != 0) {
                layoutTitleBar.setBackgroundColor(titleBarColor);
            } else {
                layoutTitleBar.setBackgroundColor(ThemeUtil.getThemeColor(context, R.attr.themeColorTitleBar));
            }
            tvStartTitle.setTextColor(ThemeUtil.getThemeColor(context, R.attr.themeColorFontTitle));
            tvBackStartTitle.setTextColor(ThemeUtil.getThemeColor(context, R.attr.themeColorFontTitle));
            tvTitle.setTextColor(ThemeUtil.getThemeColor(context, R.attr.themeColorFontTitle));
            tvRightText.setTextColor(ThemeUtil.getThemeColor(context, R.attr.themeColorFontTitle));
        }
        TitleBarUtil.setBackStyle(isLight, ivBack, 1);
        TitleBarUtil.setDeleteStyle(isLight, ivDelete, 1);
    }

    public static void setBackStyle(boolean isLight, ImageView ivBack, int backType) {
        if (isLight) {
            if (backType == 2) {
                ivBack.setImageResource(R.drawable.icon_back_2);
            } else if (backType == 3) {
                ivBack.setImageResource(R.drawable.icon_back_3);
            } else {
                ivBack.setImageResource(R.drawable.icon_back);
            }
        } else if (backType == 2) {
            ivBack.setImageResource(R.drawable.icon_back_w_2);
        } else if (backType == 3) {
            ivBack.setImageResource(R.drawable.icon_back_w_3);
        } else {
            ivBack.setImageResource(R.drawable.icon_back_w);
        }
    }

    public static void setDeleteStyle(boolean isLight, ImageView ivDelete, int backStyle) {
        if (isLight) {
            if (backStyle == 2) {
                ivDelete.setImageResource(R.drawable.icon_delete_2);
            } else if (backStyle == 3) {
                ivDelete.setImageResource(R.drawable.icon_delete_3);
            } else {
                ivDelete.setImageResource(R.drawable.icon_delete);
            }
        } else if (backStyle == 2) {
            ivDelete.setImageResource(R.drawable.icon_delete_w_2);
        } else if (backStyle == 3) {
            ivDelete.setImageResource(R.drawable.icon_delete_w_3);
        } else {
            ivDelete.setImageResource(R.drawable.icon_delete_w);
        }
    }

    public static void setSearchType(boolean isLight, ImageView ivSearch, int searchType) {
        if (isLight) {
            if (searchType == 2) {
                ivSearch.setImageResource(R.drawable.icon_search);
            } else if (searchType == 3) {
                ivSearch.setImageResource(R.drawable.icon_search);
            } else {
                ivSearch.setImageResource(R.drawable.icon_search);
            }
        } else if (searchType == 2) {
            ivSearch.setImageResource(R.drawable.icon_search_w);
        } else if (searchType == 3) {
            ivSearch.setImageResource(R.drawable.icon_search_w);
        } else {
            ivSearch.setImageResource(R.drawable.icon_search_w);
        }
    }

    public static void setSettingsType(boolean isLight, ImageView ivSettings, int settingsType) {
        if (isLight) {
            if (settingsType == 2) {
                ivSettings.setImageResource(R.drawable.icon_settings_2);
            } else if (settingsType == 3) {
                ivSettings.setImageResource(R.drawable.icon_settings_3);
            } else {
                ivSettings.setImageResource(R.drawable.icon_settings);
            }
        } else if (settingsType == 2) {
            ivSettings.setImageResource(R.drawable.icon_settings_w_2);
        } else if (settingsType == 3) {
            ivSettings.setImageResource(R.drawable.icon_settings_w_3);
        } else {
            ivSettings.setImageResource(R.drawable.icon_settings_w);
        }
    }

    public static void setMoreStyle(boolean isLight, ImageView ivMore, int moreStyle) {
        if (isLight) {
            if (moreStyle == 2) {
                ivMore.setImageResource(R.drawable.icon_more);
            } else if (moreStyle == 3) {
                ivMore.setImageResource(R.drawable.icon_more);
            } else {
                ivMore.setImageResource(R.drawable.icon_more);
            }
        } else if (moreStyle == 2) {
            ivMore.setImageResource(R.drawable.icon_more_w);
        } else if (moreStyle == 3) {
            ivMore.setImageResource(R.drawable.icon_more_w);
        } else {
            ivMore.setImageResource(R.drawable.icon_more_w);
        }
    }
}

