/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.utils;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class WavMergeUtil {
    public static void mergeWav(List<File> inputs, File output) throws IOException {
        int count;
        if (inputs.size() < 1) {
            return;
        }
        FileInputStream fis = new FileInputStream(inputs.get(0));
        FileOutputStream fos = new FileOutputStream(output);
        byte[] buffer = new byte[2048];
        int total = 0;
        while ((count = fis.read(buffer)) > -1) {
            fos.write(buffer, 0, count);
            total += count;
        }
        fis.close();
        for (int i = 1; i < inputs.size(); ++i) {
            File file = inputs.get(i);
            Header header = WavMergeUtil.resolveHeader(file);
            FileInputStream dataInputStream = header.dataInputStream;
            while ((count = dataInputStream.read(buffer)) > -1) {
                fos.write(buffer, 0, count);
                total += count;
            }
            dataInputStream.close();
        }
        fos.flush();
        fos.close();
        Header outputHeader = WavMergeUtil.resolveHeader(output);
        outputHeader.dataInputStream.close();
        RandomAccessFile res = new RandomAccessFile(output, "rw");
        res.seek(4L);
        byte[] fileLen = WavMergeUtil.intToByteArray(total + outputHeader.dataOffset - 8);
        res.write(fileLen, 0, 4);
        res.seek(outputHeader.dataSizeOffset);
        byte[] dataLen = WavMergeUtil.intToByteArray(total);
        res.write(dataLen, 0, 4);
        res.close();
    }

    private static Header resolveHeader(File wavFile) throws IOException {
        int dataLen;
        FileInputStream fis = new FileInputStream(wavFile);
        byte[] byte4 = new byte[4];
        byte[] buffer = new byte[2048];
        int readCount = 0;
        Header header = new Header();
        fis.read(byte4);
        fis.read(byte4);
        readCount += 8;
        header.fileSizeOffset = 4;
        header.fileSize = WavMergeUtil.byteArrayToInt(byte4);
        fis.read(byte4);
        fis.read(byte4);
        fis.read(byte4);
        readCount += 12;
        int fmtLen = WavMergeUtil.byteArrayToInt(byte4);
        fis.read(buffer, 0, fmtLen);
        readCount += fmtLen;
        fis.read(byte4);
        readCount += 4;
        if (WavMergeUtil.isFmt(byte4, 0)) {
            fis.read(byte4);
            int factLen = WavMergeUtil.byteArrayToInt(byte4);
            fis.read(buffer, 0, factLen);
            fis.read(byte4);
            readCount += 8 + factLen;
        }
        fis.read(byte4);
        header.dataSize = dataLen = WavMergeUtil.byteArrayToInt(byte4);
        header.dataSizeOffset = readCount;
        header.dataOffset = readCount += 4;
        header.dataInputStream = fis;
        return header;
    }

    private static boolean isRiff(byte[] bytes, int start) {
        return bytes[start + 0] == 82 && bytes[start + 1] == 73 && bytes[start + 2] == 70 && bytes[start + 3] == 70;
    }

    private static boolean isFmt(byte[] bytes, int start) {
        return bytes[start + 0] == 102 && bytes[start + 1] == 109 && bytes[start + 2] == 116 && bytes[start + 3] == 32;
    }

    private static boolean isData(byte[] bytes, int start) {
        return bytes[start + 0] == 100 && bytes[start + 1] == 97 && bytes[start + 2] == 116 && bytes[start + 3] == 97;
    }

    private static byte[] intToByteArray(int data) {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(data).array();
    }

    private static byte[] shortToByteArray(short data) {
        return ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN).putShort(data).array();
    }

    private static short byteArrayToShort(byte[] b) {
        return ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN).getShort();
    }

    private static int byteArrayToInt(byte[] b) {
        return ByteBuffer.wrap(b).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    public static long getWavLength(String filePath) {
        byte[] wavdata = WavMergeUtil.getBytes(filePath);
        if (wavdata != null && wavdata.length > 44) {
            int byteRate = WavMergeUtil.byteArrayToInt(wavdata, 28, 31);
            int waveSize = WavMergeUtil.byteArrayToInt(wavdata, 40, 43);
            return waveSize * 1000 / byteRate;
        }
        return 0L;
    }

    private static byte[] getBytes(String filePath) {
        byte[] buffer = null;
        try {
            int n;
            File file = new File(filePath);
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(1000);
            byte[] b = new byte[1000];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }

    private static int byteArrayToInt(byte[] b, int start, int end) {
        return ByteBuffer.wrap(b, start, end).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    static class Header {
        public int fileSize;
        public int fileSizeOffset;
        public int dataSize;
        public int dataSizeOffset;
        public int dataOffset;
        public FileInputStream dataInputStream;

        Header() {
        }
    }
}

