/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.view;

import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.View;
import android.view.animation.LinearInterpolator;
import androidx.annotation.Nullable;
import com.bfcy.base.R;

public class ChrysanthemumView
extends View {
    private static final String TAG = "ChrysanthemumView";
    private int mLineBold;
    private int mStartColor = Color.parseColor((String)"#99FFFFFF");
    private int mEndColor = Color.parseColor((String)"#999B9B9B");
    private int mWidth;
    private int mHeight;
    private int mLineLength;
    private int mLineCount = 12;
    private Paint mBgPaint;
    private int[] mColors;
    private boolean isAnimationStart;
    private int mStartIndex;
    private ValueAnimator mValueAnimator;

    public ChrysanthemumView(Context context) {
        this(context, null);
    }

    public ChrysanthemumView(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ChrysanthemumView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.loadAttrs(context, attrs);
        this.initPaint();
        this.initColor();
    }

    private void initColor() {
        ArgbEvaluator argbEvaluator = new ArgbEvaluator();
        this.mColors = new int[this.mLineCount];
        for (int i = this.mLineCount; i > 0; --i) {
            float alpha = (float)i / (float)this.mLineCount;
            this.mColors[this.mLineCount - i] = (Integer)argbEvaluator.evaluate(alpha, (Object)this.mStartColor, (Object)this.mEndColor);
        }
    }

    private void loadAttrs(Context context, AttributeSet attrs) {
        TypedArray array = context.obtainStyledAttributes(attrs, R.styleable.ChrysanthemumView);
        this.mStartColor = array.getColor(R.styleable.ChrysanthemumView_startColor, this.mStartColor);
        this.mEndColor = array.getColor(R.styleable.ChrysanthemumView_endColor, this.mEndColor);
        this.mLineCount = array.getInt(R.styleable.ChrysanthemumView_lineCount, this.mLineCount);
        array.recycle();
    }

    private void initPaint() {
        this.mBgPaint = new Paint();
        this.mBgPaint.setAntiAlias(true);
        this.mBgPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mBgPaint.setStrokeCap(Paint.Cap.ROUND);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = this.getViewSize(ChrysanthemumView.dp2px(this.getContext(), 40.0f), widthMeasureSpec);
        this.mHeight = this.getViewSize(ChrysanthemumView.dp2px(this.getContext(), 40.0f), heightMeasureSpec);
        this.mHeight = this.mWidth = Math.min(this.mWidth, this.mHeight);
        this.mLineLength = this.mWidth / 6;
        this.mLineBold = this.mWidth / this.mLineCount;
        this.mBgPaint.setStrokeWidth((float)this.mLineBold);
        this.setMeasuredDimension(this.mWidth, this.mHeight);
    }

    private int getViewSize(int defaultSize, int measureSpec) {
        int viewSize = defaultSize;
        int mode = View.MeasureSpec.getMode((int)measureSpec);
        int size = View.MeasureSpec.getSize((int)measureSpec);
        switch (mode) {
            case 0: {
                viewSize = defaultSize;
                break;
            }
            case -2147483648: {
                viewSize = size;
                break;
            }
            case 0x40000000: {
                viewSize = size;
                break;
            }
        }
        return viewSize;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int r = this.mWidth / 2;
        canvas.rotate(360.0f / (float)this.mLineCount, (float)r, (float)r);
        for (int i = 0; i < this.mLineCount; ++i) {
            int index = (this.mStartIndex + i) % this.mLineCount;
            this.mBgPaint.setColor(this.mColors[index]);
            canvas.drawLine((float)r, (float)(this.mLineBold >> 1), (float)r, (float)((this.mLineBold >> 1) + this.mLineLength), this.mBgPaint);
            canvas.rotate(360.0f / (float)this.mLineCount, (float)r, (float)r);
        }
    }

    public void startAnimation(int duration) {
        Log.d((String)TAG, (String)("startAnimation: " + this.mStartIndex));
        if (this.mValueAnimator == null) {
            this.mValueAnimator = ValueAnimator.ofInt((int[])new int[]{this.mLineCount, 0});
            this.mValueAnimator.setDuration((long)duration);
            this.mValueAnimator.setTarget((Object)0);
            this.mValueAnimator.setRepeatCount(-1);
            this.mValueAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mValueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    if (ChrysanthemumView.this.mStartIndex != (Integer)animation.getAnimatedValue()) {
                        ChrysanthemumView.this.mStartIndex = (Integer)animation.getAnimatedValue();
                        ChrysanthemumView.this.invalidate();
                    }
                }
            });
        }
        this.mValueAnimator.start();
        this.isAnimationStart = true;
    }

    public void startAnimation() {
        this.startAnimation(900);
    }

    public void stopAnimation() {
        Log.d((String)TAG, (String)("stopAnimation: " + this.mStartIndex));
        if (this.mValueAnimator != null) {
            this.mValueAnimator.cancel();
            this.isAnimationStart = false;
        }
    }

    public boolean isAnimationStart() {
        return this.isAnimationStart;
    }

    public static int dp2px(Context context, float dpVal) {
        return (int)TypedValue.applyDimension((int)1, (float)dpVal, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    public void detachView() {
        if (this.mValueAnimator != null) {
            this.mValueAnimator.cancel();
            this.mValueAnimator = null;
            this.isAnimationStart = false;
        }
    }
}

