/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.view;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.CycleInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.TranslateAnimation;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import androidx.core.content.ContextCompat;
import com.bfcy.base.R;
import java.util.Locale;

public class ClearAutoCompleteEditText
extends AppCompatAutoCompleteTextView
implements View.OnFocusChangeListener,
TextWatcher {
    private Drawable mClearDrawable;
    private Context context;
    private boolean hasFocus;

    public ClearAutoCompleteEditText(Context context) {
        this(context, null);
    }

    public ClearAutoCompleteEditText(Context context, AttributeSet attrs) {
        this(context, attrs, 16842859);
    }

    public ClearAutoCompleteEditText(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.context = context;
        this.init();
    }

    private void init() {
        this.mClearDrawable = TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1 ? this.getCompoundDrawables()[0] : this.getCompoundDrawables()[2];
        if (this.mClearDrawable == null) {
            this.mClearDrawable = ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.icon_clear);
        }
        DisplayMetrics localDisplayMetrics = this.context.getResources().getDisplayMetrics();
        float density = localDisplayMetrics.density;
        this.mClearDrawable.setBounds(0, 0, (int)(30.0f * density / 2.0f), (int)(30.0f * density / 2.0f));
        this.setClearIconVisible(false);
        this.setOnFocusChangeListener(this);
        this.addTextChangedListener(this);
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (this.mClearDrawable != null && event.getAction() == 1) {
            boolean isInnerHeight;
            int x = (int)event.getX();
            boolean isInnerWidth = false;
            isInnerWidth = TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1 ? x < this.getTotalPaddingLeft() + 30 && x > this.getPaddingLeft() - 30 : x > this.getWidth() - this.getTotalPaddingRight() - 30 && x < this.getWidth() - this.getPaddingRight() + 30;
            Rect rect = this.mClearDrawable.getBounds();
            int height = rect.height();
            int y = (int)event.getY();
            int distance = (this.getHeight() - height) / 2;
            boolean bl = isInnerHeight = y > distance - 30 && y < distance + height + 30;
            if (isInnerHeight && isInnerWidth) {
                this.setText("");
            }
        }
        return super.onTouchEvent(event);
    }

    private void setClearIconVisible(boolean visible) {
        Drawable drawable2;
        Drawable drawable3 = drawable2 = visible ? this.mClearDrawable : null;
        if (TextUtils.getLayoutDirectionFromLocale((Locale)Locale.getDefault()) == 1) {
            this.setCompoundDrawables(drawable2, this.getCompoundDrawables()[1], this.getCompoundDrawables()[2], this.getCompoundDrawables()[3]);
        } else {
            this.setCompoundDrawables(this.getCompoundDrawables()[0], this.getCompoundDrawables()[1], drawable2, this.getCompoundDrawables()[3]);
        }
    }

    public void onFocusChange(View v, boolean hasFocus) {
        this.hasFocus = hasFocus;
        if (hasFocus) {
            this.setClearIconVisible(this.getText().length() > 0);
        } else {
            this.setClearIconVisible(false);
        }
    }

    public void onTextChanged(CharSequence text, int start, int lengthBefore, int lengthAfter) {
        if (this.hasFocus) {
            this.setClearIconVisible(text.length() > 0);
        }
    }

    public void beforeTextChanged(CharSequence s, int start, int count, int after) {
    }

    public void afterTextChanged(Editable s) {
    }

    public void setShakeAnimation() {
        this.setAnimation(ClearAutoCompleteEditText.shakeAnimation(5));
    }

    public static Animation shakeAnimation(int counts) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 10.0f, 0.0f, 0.0f);
        translateAnimation.setInterpolator((Interpolator)new CycleInterpolator((float)counts));
        translateAnimation.setDuration(1000L);
        return translateAnimation;
    }
}

