/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.view;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.style.ClickableSpan;
import android.view.MotionEvent;
import android.view.View;
import android.widget.TextView;
import com.bfcy.base.view.ClickableImageSpan;

public class ClickableMovementMethod
extends LinkMovementMethod {
    private static ClickableMovementMethod sInstance;

    public static ClickableMovementMethod getInstance() {
        if (sInstance == null) {
            sInstance = new ClickableMovementMethod();
        }
        return sInstance;
    }

    public boolean onTouchEvent(TextView widget, Spannable buffer, MotionEvent event) {
        int action = event.getAction();
        if (action == 1 || action == 0) {
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            Layout layout2 = widget.getLayout();
            int line = layout2.getLineForVertical(y += widget.getScrollY());
            int off = layout2.getOffsetForHorizontal(line, (float)(x += widget.getScrollX()));
            ClickableSpan[] link = (ClickableSpan[])buffer.getSpans(off, off, ClickableSpan.class);
            ClickableImageSpan[] imageSpans = (ClickableImageSpan[])buffer.getSpans(off, off, ClickableImageSpan.class);
            if (link.length != 0) {
                if (action == 1) {
                    link[0].onClick((View)widget);
                } else if (action == 0) {
                    Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)link[0]), (int)buffer.getSpanEnd((Object)link[0]));
                }
                return true;
            }
            if (imageSpans.length != 0) {
                if (action == 1) {
                    imageSpans[0].onClick((View)widget);
                } else if (action == 0) {
                    Selection.setSelection((Spannable)buffer, (int)buffer.getSpanStart((Object)imageSpans[0]), (int)buffer.getSpanEnd((Object)imageSpans[0]));
                }
                return true;
            }
            Selection.removeSelection((Spannable)buffer);
        }
        return false;
    }
}

