/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.view.dialog;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import com.bfcy.base.R;

public class CommonDialog
extends Dialog {
    public CommonDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
    }

    public static class Builder {
        private final Context mContext;
        private CharSequence mTitle;
        private CharSequence mMessage;
        private boolean mCancelable = true;
        private CharSequence mPositiveButtonText;
        private CharSequence mNegativeButtonText;
        private CharSequence mNeutralButtonText;
        private DialogInterface.OnClickListener mNegativeButtonListener;
        private DialogInterface.OnClickListener mPositiveButtonListener;
        private DialogInterface.OnClickListener mNeutralButtonListener;

        public Builder(@NonNull Context context) {
            this.mContext = context;
        }

        public Builder setTitle(@StringRes int titleId) {
            this.mTitle = this.mContext.getString(titleId);
            return this;
        }

        public Builder setTitle(@Nullable CharSequence title) {
            this.mTitle = title;
            return this;
        }

        public Builder setMessage(@StringRes int messageId) {
            this.mMessage = this.mContext.getString(messageId);
            return this;
        }

        public Builder setMessage(@Nullable CharSequence message) {
            this.mMessage = message;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.mCancelable = cancelable;
            return this;
        }

        public Builder setPositiveButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mPositiveButtonText = text;
            this.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setPositiveButton(@StringRes int textId, DialogInterface.OnClickListener listener) {
            this.mPositiveButtonText = this.mContext.getText(textId);
            this.mPositiveButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(@StringRes int textId, DialogInterface.OnClickListener listener) {
            this.mNegativeButtonText = this.mContext.getText(textId);
            this.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNegativeButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mNegativeButtonText = text;
            this.mNegativeButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(@StringRes int textId, DialogInterface.OnClickListener listener) {
            this.mNeutralButtonText = this.mContext.getText(textId);
            this.mNeutralButtonListener = listener;
            return this;
        }

        public Builder setNeutralButton(CharSequence text, DialogInterface.OnClickListener listener) {
            this.mNeutralButtonText = text;
            this.mNeutralButtonListener = listener;
            return this;
        }

        public CommonDialog create() {
            CommonDialog dialog = new CommonDialog(this.mContext, R.style.Dialog_Common);
            dialog.setCancelable(this.mCancelable);
            View parentView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.dialog_common, null);
            TextView tvTitle = (TextView)parentView.findViewById(R.id.tvTitle);
            TextView tvMessage = (TextView)parentView.findViewById(R.id.tvMessage);
            View layoutPositiveButton = parentView.findViewById(R.id.layoutPositiveButton);
            View layoutNegativeButton = parentView.findViewById(R.id.layoutNegativeButton);
            View layoutNeutralButton = parentView.findViewById(R.id.layoutNeutralButton);
            TextView positiveButton = (TextView)parentView.findViewById(R.id.positiveButton);
            TextView negativeButton = (TextView)parentView.findViewById(R.id.negativeButton);
            TextView neutralButton = (TextView)parentView.findViewById(R.id.neutralButton);
            tvTitle.setText(this.mTitle);
            tvMessage.setText(this.mMessage);
            if (this.mPositiveButtonListener != null) {
                layoutPositiveButton.setVisibility(0);
                positiveButton.setText(this.mPositiveButtonText);
                positiveButton.setOnClickListener(v -> this.mPositiveButtonListener.onClick((DialogInterface)dialog, -1));
            } else {
                layoutPositiveButton.setVisibility(8);
            }
            if (this.mNegativeButtonListener != null) {
                layoutNegativeButton.setVisibility(0);
                negativeButton.setText(this.mNegativeButtonText);
                negativeButton.setOnClickListener(v -> this.mNegativeButtonListener.onClick((DialogInterface)dialog, -2));
            } else {
                layoutNegativeButton.setVisibility(8);
            }
            if (this.mNeutralButtonListener != null) {
                layoutNeutralButton.setVisibility(0);
                neutralButton.setText(this.mNeutralButtonText);
                neutralButton.setOnClickListener(v -> this.mNeutralButtonListener.onClick((DialogInterface)dialog, -3));
            } else {
                layoutNeutralButton.setVisibility(8);
            }
            dialog.setContentView(parentView);
            return dialog;
        }

        public CommonDialog show() {
            CommonDialog dialog = this.create();
            dialog.show();
            return dialog;
        }
    }
}

