/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.view.dialog;

import android.annotation.SuppressLint;
import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.bfcy.base.R;
import com.bfcy.base.utils.DisplayUtil;

public class CustomDialog
extends Dialog {
    public CustomDialog(Context context, int theme) {
        super(context, theme);
    }

    public void setPositiveResource() {
    }

    @SuppressLint(value={"InflateParams"})
    public static class Builder {
        private Context context;
        private String title;
        private String messageTips;
        private CharSequence message;
        private String positiveButtonText;
        private String negativeButtonText;
        private View contentView;
        private int mGravity = 17;
        private View.OnClickListener messageClick;
        private DialogInterface.OnClickListener positiveButtonClickListener;
        private DialogInterface.OnClickListener negativeButtonClickListener;
        private int positiveResouce = 0;
        private int negativeResouce = 0;

        public Builder(Context context) {
            this.context = context;
        }

        public Builder setMessage(CharSequence message) {
            this.message = message;
            return this;
        }

        public Builder setMessage(int message) {
            this.message = this.context.getText(message);
            return this;
        }

        public Builder setTitle(int title) {
            this.title = (String)this.context.getText(title);
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setContentView(View v) {
            this.contentView = v;
            return this;
        }

        public Builder setPositiveButton(int positiveButtonText, DialogInterface.OnClickListener listener) {
            this.positiveButtonText = (String)this.context.getText(positiveButtonText);
            this.positiveButtonClickListener = listener;
            return this;
        }

        public Builder setPositiveButton(String positiveButtonText, DialogInterface.OnClickListener listener) {
            this.positiveButtonText = positiveButtonText;
            this.positiveButtonClickListener = listener;
            return this;
        }

        public Builder setNegativeButton(int negativeButtonText, DialogInterface.OnClickListener listener) {
            this.negativeButtonText = (String)this.context.getText(negativeButtonText);
            this.negativeButtonClickListener = listener;
            return this;
        }

        public Builder setNegativeButton(String negativeButtonText, DialogInterface.OnClickListener listener) {
            this.negativeButtonText = negativeButtonText;
            this.negativeButtonClickListener = listener;
            return this;
        }

        public CustomDialog create() {
            LayoutInflater inflater = (LayoutInflater)this.context.getSystemService("layout_inflater");
            final CustomDialog dialog = new CustomDialog(this.context, R.style.Dialog_Common);
            dialog.setCanceledOnTouchOutside(false);
            View layout2 = inflater.inflate(R.layout.dialog_common_2, null);
            ((TextView)layout2.findViewById(R.id.title)).setText((CharSequence)this.title);
            if (this.positiveButtonText != null) {
                ((TextView)layout2.findViewById(R.id.positiveButton)).setText((CharSequence)this.positiveButtonText);
                if (this.positiveResouce != 0) {
                    ((TextView)layout2.findViewById(R.id.positiveButton)).setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.white));
                    layout2.findViewById(R.id.positiveButton).setBackgroundResource(this.positiveResouce);
                }
                if (this.positiveButtonClickListener != null) {
                    layout2.findViewById(R.id.positiveButton).setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            positiveButtonClickListener.onClick((DialogInterface)dialog, -1);
                        }
                    });
                }
                if (this.negativeButtonClickListener == null) {
                    ((TextView)layout2.findViewById(R.id.positiveButton)).setWidth(DisplayUtil.dp2px(this.context, 150.0f));
                }
            } else {
                layout2.findViewById(R.id.positiveButton_layout).setVisibility(8);
            }
            if (this.negativeButtonText != null) {
                ((TextView)layout2.findViewById(R.id.negativeButton)).setText((CharSequence)this.negativeButtonText);
                if (this.negativeResouce != 0) {
                    ((TextView)layout2.findViewById(R.id.negativeButton)).setTextColor(ContextCompat.getColor((Context)this.context, (int)R.color.com_yellow));
                    layout2.findViewById(R.id.negativeButton).setBackgroundResource(this.negativeResouce);
                }
                if (this.negativeButtonClickListener != null) {
                    layout2.findViewById(R.id.negativeButton).setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            negativeButtonClickListener.onClick((DialogInterface)dialog, -2);
                        }
                    });
                    if (this.positiveButtonClickListener == null) {
                        ((TextView)layout2.findViewById(R.id.negativeButton)).setWidth(DisplayUtil.dp2px(this.context, 150.0f));
                    }
                }
            } else {
                layout2.findViewById(R.id.negativeButton_layout).setVisibility(8);
            }
            if (this.message != null) {
                ((TextView)layout2.findViewById(R.id.message)).setText(this.message);
                ((TextView)layout2.findViewById(R.id.message)).setGravity(this.mGravity);
            } else if (this.contentView != null) {
                ((LinearLayout)layout2.findViewById(R.id.content)).removeAllViews();
                ((LinearLayout)layout2.findViewById(R.id.content)).addView(this.contentView, new ViewGroup.LayoutParams(-2, -2));
            }
            dialog.setContentView(layout2);
            return dialog;
        }

        public void setContentViewGravity(int contentViewGravity) {
            this.mGravity = contentViewGravity;
        }

        public void setMessageTips(String messageTips) {
            this.messageTips = messageTips;
        }

        public void setMessageClick(View.OnClickListener click) {
            this.messageClick = click;
        }

        public void setPositiveResource(int positiveResource) {
            this.positiveResouce = positiveResource;
        }

        public void setNegativeResource(int negativeResource) {
            this.negativeResouce = negativeResource;
        }
    }
}

