/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.NetworkSpecifier;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiNetworkSpecifier;
import android.net.wifi.WifiNetworkSuggestion;
import android.os.Build;
import android.os.PatternMatcher;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import com.bfcy.base.beans.WifiData;
import com.bfcy.base.log.Logger;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WifiManagerHelper {
    private static final String TAG = "WifiManagerHelper";
    private static volatile WifiManagerHelper instance;
    private final Context mContext;
    private final WifiManager mWifiManager;
    private final ConnectivityManager mConnectivityManager;
    private WifiScanListener wifiScanListener;
    private WifiConnectListener wifiConnectListener;
    private String connectWifiName;
    private boolean registerNetworkCallback = false;
    private List<WifiConfiguration> wifiConfigList;
    ConnectivityManager.NetworkCallback networkCallback = new ConnectivityManager.NetworkCallback(){

        public void onAvailable(Network network) {
            Logger.d(WifiManagerHelper.TAG, "WifiManagerHelper--\u8fde\u63a5\u6210\u529f: ");
            if (WifiManagerHelper.this.wifiConnectListener != null) {
                WifiManagerHelper.this.wifiConnectListener.onSuccess("");
            }
        }

        public void onUnavailable() {
            Logger.d(WifiManagerHelper.TAG, "WifiManagerHelper--\u8fde\u63a5\u5931\u8d25: ");
            if (WifiManagerHelper.this.wifiConnectListener != null) {
                WifiManagerHelper.this.wifiConnectListener.onFailure();
            }
        }
    };
    BroadcastReceiver WifiManagerReceiver = new BroadcastReceiver(){

        public void onReceive(Context c, Intent intent) {
            Logger.i("tag", "WifiManagerHelper--wifiScanReceiver--action: " + intent.getAction());
            if ("android.net.wifi.SCAN_RESULTS".equals(intent.getAction())) {
                List wifiList = WifiManagerHelper.this.mWifiManager.getScanResults();
                Logger.i("tag", "WifiManagerHelper--wifiScanReceiver--wifiList: " + wifiList.size());
                WifiManagerHelper.this.wifiScanListener.onSuccess(WifiManagerHelper.this.convertData(wifiList));
                return;
            }
            if ("android.net.wifi.action.WIFI_NETWORK_SUGGESTION_POST_CONNECTION".equals(intent.getAction())) {
                return;
            }
            boolean success = intent.getBooleanExtra("resultsUpdated", false);
            Logger.i("tag", "WifiManagerHelper--wifiScanReceiver--success: " + success);
        }
    };

    private WifiManagerHelper(Context context) {
        this.mContext = context.getApplicationContext();
        this.mWifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        this.mConnectivityManager = (ConnectivityManager)this.mContext.getSystemService("connectivity");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static WifiManagerHelper getInstance(Context context) {
        if (instance != null) return instance;
        Class<WifiManagerHelper> clazz = WifiManagerHelper.class;
        synchronized (WifiManagerHelper.class) {
            if (instance != null) return instance;
            instance = new WifiManagerHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void startScan(WifiScanListener scanListener) {
        this.wifiScanListener = scanListener;
        boolean success = this.mWifiManager.startScan();
        Logger.i("tag", "WifiManagerHelper--startScan--success: " + success);
        if (success) {
            if (this.wifiScanListener != null) {
                List wifiList = this.mWifiManager.getScanResults();
                Logger.i("tag", "WifiManagerHelper--startScan--wifiList: " + wifiList.size());
                this.wifiScanListener.onSuccess(this.convertData(wifiList));
            }
        } else if (this.wifiScanListener != null) {
            this.wifiScanListener.onFailure();
        }
        try {
            if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
                Logger.i("tag", "WifiManagerHelper--wifiConfigList--\u6ca1\u6709\u6743\u9650: ");
                return;
            }
            this.wifiConfigList = this.mWifiManager.getConfiguredNetworks();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logger.i("tag", "WifiManagerHelper--wifiConfigList--size: " + this.wifiConfigList.size());
    }

    private List<WifiData> convertData(List<ScanResult> wifiList) {
        ArrayList<WifiData> wifiDataList = new ArrayList<WifiData>();
        if (wifiList != null && wifiList.size() > 0) {
            for (ScanResult scanResult : wifiList) {
                WifiData wifiData = new WifiData();
                wifiData.setWifiName(scanResult.SSID);
                wifiData.setWifiStrength(Math.abs(scanResult.level));
                wifiData.setWifiType(WifiManagerHelper.getWifiType(scanResult.frequency));
                wifiData.setEncryptionType(this.getEncryptionType(scanResult.capabilities));
                wifiDataList.add(wifiData);
            }
        }
        return wifiDataList;
    }

    private int getEncryptionType(String capabilities) {
        if ("".equals(capabilities) || "[ESS]".equals(capabilities)) {
            return 1;
        }
        return 3;
    }

    private WifiData convertData(WifiInfo mWifiInfo) {
        String info;
        WifiData wifiData = null;
        if (mWifiInfo != null) {
            Logger.i(TAG, "WifiManagerHelper----mWifiInfo1: " + mWifiInfo.toString());
            String wifiSSID = mWifiInfo.getSSID();
            String wifiBSSID = mWifiInfo.getBSSID();
            int wifiStrength = mWifiInfo.getRssi();
            String wifiMacAddress = "";
            if (ActivityCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
                wifiMacAddress = mWifiInfo.getMacAddress();
            }
            int wifiIpAddress = mWifiInfo.getIpAddress();
            int frequency = mWifiInfo.getFrequency();
            info = "wifiSSID-" + wifiSSID + "; wifiBSSID-" + wifiBSSID + "; wifiStrength-" + wifiStrength + "; frequency-" + frequency + "; wifiMacAddress-" + wifiMacAddress + "; wifiIpAddress-" + wifiIpAddress;
            wifiData = new WifiData();
            wifiData.setWifiName(wifiSSID);
            wifiData.setWifiType(WifiManagerHelper.getWifiType(frequency));
            wifiData.setWifiStrength(wifiStrength);
        } else {
            info = "WifiInfo is null";
        }
        Logger.i(TAG, "WifiManagerHelper----mWifiInfo: " + info);
        return wifiData;
    }

    private static int getWifiType(int frequency) {
        int type = 0;
        if (frequency >= 2400 && frequency < 3000) {
            type = 1;
        } else if (frequency >= 5000 && frequency < 6000) {
            type = 2;
        }
        return type;
    }

    public int getWifiStatus() {
        if (this.mWifiManager != null) {
            int status = this.mWifiManager.getWifiState();
            Logger.i(TAG, "WifiManagerHelper--getWifiStatus--status: " + status);
            return status;
        }
        Logger.i(TAG, "WifiManagerHelper--getWifiStatus--mWifiManager is null");
        return 4;
    }

    public boolean isWifiConnected() {
        NetworkInfo networkInfo = this.mConnectivityManager.getNetworkInfo(1);
        if (networkInfo != null) {
            return networkInfo.getType() == 1 && networkInfo.isConnected();
        }
        return false;
    }

    public WifiData getConnectedWifiInfo() {
        WifiData wifiData = null;
        try {
            WifiInfo mWifiInfo = this.mWifiManager.getConnectionInfo();
            wifiData = this.convertData(mWifiInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return wifiData;
    }

    public void connectWifi(String wifiName, String pwd, int type, WifiConnectListener listener) {
        Logger.d(TAG, "WifiManagerHelper--connectWifi--\u5f00\u59cb\u8fde\u63a5--wifiName: " + wifiName + "; pwd: " + pwd + "; type: " + type);
        this.connectWifiName = wifiName;
        this.wifiConnectListener = listener;
        if (Build.VERSION.SDK_INT >= 29) {
            if (type == 1) {
                this.connectWifiPeerToPeer(wifiName, pwd);
            } else if (type == 3) {
                this.connectWifiPeerToPeer(wifiName, pwd);
            }
        } else {
            this.addNetwork(wifiName, pwd, type);
        }
    }

    public void addNetwork(String wifiName, String pwd, int type) {
        boolean isSuccess;
        boolean isConfig = false;
        int netId = 0;
        if (this.wifiConfigList != null && this.wifiConfigList.size() > 0) {
            Logger.i("tag", "WifiManagerHelper--addNetwork--\u914d\u7f6e\u5217\u8868--size: " + this.wifiConfigList.size());
            for (WifiConfiguration configuration : this.wifiConfigList) {
                if (!configuration.SSID.replace("\"", "").equals(wifiName)) continue;
                isConfig = true;
                netId = configuration.networkId;
                Logger.d(TAG, "WifiManagerHelper--addNetwork--\u914d\u7f6e\u5217\u8868\u6709--netId: " + netId);
                break;
            }
        } else {
            Logger.d(TAG, "WifiManagerHelper--addNetwork--wifi\u914d\u7f6e\u5217\u8868\u4e3a\u7a7a");
        }
        if (!isConfig) {
            Logger.d(TAG, "WifiManagerHelper--addNetwork--\u914d\u7f6e\u5217\u8868\u6ca1\u6709\u8981\u8fde\u63a5\u7684wifi\uff0c\u521b\u5efawifi\u4fe1\u606f");
            netId = this.mWifiManager.addNetwork(this.CreateWifiInfo(wifiName, pwd, type));
        }
        if (isSuccess = this.mWifiManager.enableNetwork(netId, true)) {
            Logger.d(TAG, "WifiManagerHelper--addNetwork--\u8fde\u63a5\u6210\u529f: " + wifiName);
            if (this.wifiConnectListener != null) {
                this.wifiConnectListener.onSuccess(wifiName);
            }
        } else {
            Logger.d(TAG, "WifiManagerHelper--addNetwork--\u8fde\u63a5\u5931\u8d25");
            if (this.wifiConnectListener != null) {
                this.wifiConnectListener.onFailure();
            }
        }
    }

    @RequiresApi(api=29)
    public void connectWifiPeerToPeer(String wifiName, String pwd) {
        try {
            WifiNetworkSpecifier specifier = new WifiNetworkSpecifier.Builder().setSsidPattern(new PatternMatcher(wifiName, 1)).setWpa2Passphrase(pwd).build();
            NetworkRequest request = new NetworkRequest.Builder().addTransportType(1).removeCapability(12).setNetworkSpecifier((NetworkSpecifier)specifier).build();
            this.mConnectivityManager.requestNetwork(request, this.networkCallback);
            this.registerNetworkCallback = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void unregisterNetworkCallback() {
        Logger.d(TAG, "WifiManagerHelper--\u79fb\u9664\u76d1\u542c: ");
        if (this.registerNetworkCallback) {
            this.registerNetworkCallback = false;
            this.mConnectivityManager.unregisterNetworkCallback(this.networkCallback);
        }
    }

    @RequiresApi(api=29)
    public void connectWifiInternet(String wifiName, String pwd, WifiConnectListener listener) {
        final WifiNetworkSuggestion suggestion1 = new WifiNetworkSuggestion.Builder().setSsid(wifiName).setIsAppInteractionRequired(true).build();
        final WifiNetworkSuggestion suggestion2 = new WifiNetworkSuggestion.Builder().setSsid(wifiName).setWpa2Passphrase(pwd).setIsAppInteractionRequired(false).build();
        final WifiNetworkSuggestion suggestion3 = new WifiNetworkSuggestion.Builder().setSsid(wifiName).setWpa3Passphrase(pwd).setIsAppInteractionRequired(true).build();
        ArrayList<WifiNetworkSuggestion> suggestionsList = new ArrayList<WifiNetworkSuggestion>(){
            {
                this.add(suggestion1);
                this.add(suggestion2);
                this.add(suggestion3);
            }
        };
        WifiManager wifiManager = (WifiManager)this.mContext.getApplicationContext().getSystemService("wifi");
        int status = wifiManager.addNetworkSuggestions((List)suggestionsList);
        if (status != 0) {
            listener.onFailure();
        }
        Logger.d(TAG, "WifiManagerHelper--connectWifi29--status: " + status);
    }

    public WifiConfiguration CreateWifiInfo(String SSID, String Password, int Type2) {
        WifiConfiguration config = new WifiConfiguration();
        config.allowedAuthAlgorithms.clear();
        config.allowedGroupCiphers.clear();
        config.allowedKeyManagement.clear();
        config.allowedPairwiseCiphers.clear();
        config.allowedProtocols.clear();
        config.SSID = "\"" + SSID + "\"";
        if (Type2 == 1) {
            config.allowedKeyManagement.set(0);
        }
        if (Type2 == 2) {
            config.hiddenSSID = true;
            config.wepKeys[0] = "\"" + Password + "\"";
            config.allowedAuthAlgorithms.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedGroupCiphers.set(2);
            config.allowedGroupCiphers.set(0);
            config.allowedGroupCiphers.set(1);
            config.allowedKeyManagement.set(0);
            config.wepTxKeyIndex = 0;
        }
        if (Type2 == 3) {
            config.preSharedKey = "\"" + Password + "\"";
            config.hiddenSSID = true;
            config.allowedAuthAlgorithms.set(0);
            config.allowedGroupCiphers.set(2);
            config.allowedKeyManagement.set(1);
            config.allowedPairwiseCiphers.set(1);
            config.allowedGroupCiphers.set(3);
            config.allowedPairwiseCiphers.set(2);
            config.status = 2;
        }
        return config;
    }

    public WifiConfiguration createWifiInfo(String ssid, String passawrd, int paramInt, String type) {
        WifiConfiguration localWifiConfiguration1 = new WifiConfiguration();
        localWifiConfiguration1.allowedAuthAlgorithms.clear();
        localWifiConfiguration1.allowedGroupCiphers.clear();
        localWifiConfiguration1.allowedKeyManagement.clear();
        localWifiConfiguration1.allowedPairwiseCiphers.clear();
        localWifiConfiguration1.allowedProtocols.clear();
        if (type.equals("wt")) {
            localWifiConfiguration1.SSID = "\"" + ssid + "\"";
            WifiConfiguration localWifiConfiguration2 = this.isExsits(ssid);
            if (localWifiConfiguration2 != null) {
                this.mWifiManager.removeNetwork(localWifiConfiguration2.networkId);
            }
            if (paramInt == 1) {
                localWifiConfiguration1.wepKeys[0] = "";
                localWifiConfiguration1.allowedKeyManagement.set(0);
                localWifiConfiguration1.wepTxKeyIndex = 0;
            } else if (paramInt == 2) {
                localWifiConfiguration1.hiddenSSID = true;
                localWifiConfiguration1.wepKeys[0] = "\"" + passawrd + "\"";
            } else {
                localWifiConfiguration1.preSharedKey = "\"" + passawrd + "\"";
                localWifiConfiguration1.hiddenSSID = true;
                localWifiConfiguration1.allowedAuthAlgorithms.set(0);
                localWifiConfiguration1.allowedGroupCiphers.set(2);
                localWifiConfiguration1.allowedKeyManagement.set(1);
                localWifiConfiguration1.allowedPairwiseCiphers.set(1);
                localWifiConfiguration1.allowedGroupCiphers.set(3);
                localWifiConfiguration1.allowedPairwiseCiphers.set(2);
            }
        } else {
            localWifiConfiguration1.SSID = ssid;
            localWifiConfiguration1.allowedAuthAlgorithms.set(1);
            localWifiConfiguration1.allowedGroupCiphers.set(3);
            localWifiConfiguration1.allowedGroupCiphers.set(2);
            localWifiConfiguration1.allowedGroupCiphers.set(0);
            localWifiConfiguration1.allowedGroupCiphers.set(1);
            localWifiConfiguration1.allowedKeyManagement.set(0);
            localWifiConfiguration1.wepTxKeyIndex = 0;
            if (paramInt == 1) {
                localWifiConfiguration1.wepKeys[0] = "";
                localWifiConfiguration1.allowedKeyManagement.set(0);
                localWifiConfiguration1.wepTxKeyIndex = 0;
            } else if (paramInt == 2) {
                localWifiConfiguration1.hiddenSSID = true;
                localWifiConfiguration1.wepKeys[0] = passawrd;
            } else if (paramInt == 3) {
                localWifiConfiguration1.preSharedKey = passawrd;
                localWifiConfiguration1.allowedAuthAlgorithms.set(0);
                localWifiConfiguration1.allowedProtocols.set(1);
                localWifiConfiguration1.allowedProtocols.set(0);
                localWifiConfiguration1.allowedKeyManagement.set(1);
                localWifiConfiguration1.allowedPairwiseCiphers.set(2);
                localWifiConfiguration1.allowedPairwiseCiphers.set(1);
            }
        }
        return localWifiConfiguration1;
    }

    private WifiConfiguration isExsits(String str) {
        WifiConfiguration localWifiConfiguration;
        Iterator localIterator = this.mWifiManager.getConfiguredNetworks().iterator();
        do {
            if (!localIterator.hasNext()) {
                return null;
            }
            localWifiConfiguration = (WifiConfiguration)localIterator.next();
        } while (!localWifiConfiguration.SSID.equals("\"" + str + "\""));
        return localWifiConfiguration;
    }

    public void registerWifiScanReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.wifi.SCAN_RESULTS");
        if (Build.VERSION.SDK_INT >= 29) {
            intentFilter.addAction("android.net.wifi.action.WIFI_NETWORK_SUGGESTION_POST_CONNECTION");
        }
        this.mContext.registerReceiver(this.WifiManagerReceiver, intentFilter);
    }

    public void unregisterWifiScanReceiver() {
        this.mContext.unregisterReceiver(this.WifiManagerReceiver);
    }

    @Deprecated
    public void openWifi() {
        this.mWifiManager.setWifiEnabled(true);
    }

    @Deprecated
    public void closeWifi() {
        this.mWifiManager.setWifiEnabled(false);
    }

    public static interface WifiScanListener {
        public void onSuccess(List<WifiData> var1);

        public void onFailure();
    }

    public static interface WifiConnectListener {
        public void onSuccess(String var1);

        public void onFailure();
    }
}

