/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.wifi;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.bfcy.base.beans.WifiData;
import com.bfcy.base.log.Logger;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class WifiUtil {
    private static final String TAG = "WifiUtil";

    public static boolean isNetworkAvailable(Context c) {
        Context context = c.getApplicationContext();
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo[] networkInfo = connectivityManager.getAllNetworkInfo();
        if (networkInfo != null && networkInfo.length > 0) {
            for (int i = 0; i < networkInfo.length; ++i) {
                NetworkInfo aNetworkInfo = networkInfo[i];
                if (aNetworkInfo != null) {
                    Logger.i("tag", "WifiUtil--i-" + i + "; NetType-" + aNetworkInfo.getType() + "; TypeName-" + aNetworkInfo.getTypeName() + "; State-" + aNetworkInfo.getState());
                }
                if (aNetworkInfo == null || aNetworkInfo.getState() != NetworkInfo.State.CONNECTED) continue;
                return true;
            }
        }
        return false;
    }

    public static int getWifiStatus(Context context) {
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        int status = wifiManager.getWifiState();
        Logger.i(TAG, "WifiUtil--getWifiStatus--status: " + status);
        return status;
    }

    public static WifiData getConnectedWifiInfo(Context context) {
        WifiData wifiData = null;
        String info = "";
        try {
            if (WifiUtil.isWifiConnect(context)) {
                WifiManager mWifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
                WifiInfo mWifiInfo = mWifiManager.getConnectionInfo();
                if (mWifiInfo != null) {
                    Logger.i("tag", "WifiUtil--mWifiInfo1: " + mWifiInfo.toString());
                    String wifiSSID = mWifiInfo.getSSID();
                    String wifiBSSID = mWifiInfo.getBSSID();
                    int wifiStrength = mWifiInfo.getRssi();
                    String wifiMacAddress = mWifiInfo.getMacAddress();
                    int wifiIpAddress = mWifiInfo.getIpAddress();
                    int frequency = mWifiInfo.getFrequency();
                    info = "wifiSSID-" + wifiSSID + "; wifiBSSID-" + wifiBSSID + "; wifiStrength-" + wifiStrength + "; frequency-" + frequency + "; wifiMacAddress-" + wifiMacAddress + "; wifiIpAddress-" + wifiIpAddress;
                    wifiData = new WifiData();
                    wifiData.setWifiName(wifiSSID);
                    int type = 0;
                    if (frequency >= 2000 && frequency < 3000) {
                        type = 1;
                    } else if (frequency >= 5000 && frequency < 6000) {
                        type = 2;
                    }
                    wifiData.setWifiType(type);
                    wifiData.setWifiStrength(wifiStrength);
                } else {
                    info = "WifiInfo is null";
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Logger.i("tag", "WifiUtil--mWifiInfo: " + info);
        return wifiData;
    }

    public static boolean isWifiConnect(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
        if (networkInfo != null) {
            return networkInfo.getType() == 1 && networkInfo.isConnected();
        }
        return false;
    }

    public static boolean is4gConnect(Context context) {
        ConnectivityManager connManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = connManager.getNetworkInfo(0);
        return networkInfo != null && networkInfo.getType() == 0 && networkInfo.isConnected();
    }

    public static boolean isWifi(Context context) {
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo activeNetInfo = connectivityManager.getActiveNetworkInfo();
        return activeNetInfo != null && activeNetInfo.getType() == 1;
    }

    public static String getNetInfo(Context context) {
        String info = "";
        try {
            if (WifiUtil.isWifiConnect(context)) {
                WifiManager mWifiManager = (WifiManager)context.getSystemService("wifi");
                WifiInfo mWifiInfo = mWifiManager.getConnectionInfo();
                if (mWifiInfo != null) {
                    String wifiSSID = mWifiInfo.getSSID();
                    String wifiBSSID = mWifiInfo.getBSSID();
                    int wifiStrength = mWifiInfo.getRssi();
                    String wifiMacAddress = mWifiInfo.getMacAddress();
                    int wifiIpAddress = mWifiInfo.getIpAddress();
                    info = "wifiSSID-" + wifiSSID + "; wifiBSSID-" + wifiBSSID + "; wifiStrength-" + wifiStrength + "; wifiMacAddress-" + wifiMacAddress + "; wifiIpAddress-" + wifiIpAddress;
                } else {
                    info = "WifiInfo is null";
                }
            } else {
                info = WifiUtil.is4gConnect(context) ? "4G connected " : "Network not connected ";
            }
        }
        catch (Exception ex) {
            Log.e((String)"IP Address", (String)ex.toString());
        }
        info = info + "; IpV4-" + WifiUtil.getlocalIpV4() + "; IpV6-" + WifiUtil.getLocalIpV6();
        Logger.i("tag", "WifiUtil--mWifiInfo: " + info);
        return info;
    }

    public static String getLocalIpV6() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    Logger.i("tag", "WifiUtil--ip1  " + inetAddress.getHostAddress());
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet6Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception ex) {
            Log.e((String)"IP Address", (String)ex.toString());
        }
        return null;
    }

    public static String getlocalIpV4() {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en.hasMoreElements()) {
                NetworkInterface intf = en.nextElement();
                Enumeration<InetAddress> enumIpAddr = intf.getInetAddresses();
                while (enumIpAddr.hasMoreElements()) {
                    InetAddress inetAddress = enumIpAddr.nextElement();
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress()) continue;
                    Logger.i("tag", "WifiUtil--ip==========" + inetAddress.getHostAddress());
                    System.out.println("ip==========" + inetAddress.getHostAddress());
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static List<WifiData> getWifiInfoList(Context context) {
        List<ScanResult> wifiList = WifiUtil.scanWifiList(context);
        ArrayList<WifiData> wifiDataList = new ArrayList<WifiData>();
        if (wifiList != null && wifiList.size() > 0) {
            for (ScanResult scanResult : wifiList) {
                WifiData wifiData = new WifiData();
                wifiData.setWifiName(scanResult.SSID);
                wifiData.setWifiStrength(Math.abs(scanResult.level));
                wifiData.setWifiType(WifiUtil.getWifiType(scanResult.frequency));
                wifiDataList.add(wifiData);
            }
        }
        return wifiDataList;
    }

    private static int getWifiType(int frequency) {
        int type = 0;
        if (frequency >= 2400 && frequency < 3000) {
            type = 1;
        } else if (frequency >= 5000 && frequency < 6000) {
            type = 2;
        }
        return type;
    }

    public static List<ScanResult> scanWifiList(Context context) {
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        ArrayList<ScanResult> wifiList = null;
        if (wifiManager.isWifiEnabled()) {
            wifiManager.startScan();
            List scanWifiList = wifiManager.getScanResults();
            wifiList = new ArrayList<ScanResult>();
            if (scanWifiList != null && scanWifiList.size() > 0) {
                for (int i = 0; i < scanWifiList.size(); ++i) {
                    ScanResult scanResult = (ScanResult)scanWifiList.get(i);
                    Logger.i(TAG, "scanWifiList--\u641c\u7d22\u7684wifi\u4fe1\u606f\uff1a" + scanResult.toString());
                    wifiList.add(scanResult);
                }
            } else {
                Logger.i(TAG, "scanWifiList--\u6ca1\u6709\u641c\u7d22\u5230wifi");
            }
        } else {
            Logger.i(TAG, "scanWifiList--wifi\u672a\u6253\u5f00");
        }
        return wifiList;
    }

    public static void openWifi(Context context) {
        Logger.i(TAG, "WifiUtil--openWifi");
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        wifiManager.setWifiEnabled(true);
    }

    public static void closeWifi(Context context) {
        Logger.i(TAG, "WifiUtil--closeWifi");
        WifiManager wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        wifiManager.setWifiEnabled(false);
    }
}

