/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.xml;

import android.util.Log;
import com.bfcy.base.beans.Student;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DomParser {
    private List<Student> students = null;

    public void getStudentsFromXMl(InputStream stream) throws Exception {
        int i;
        this.students = new ArrayList<Student>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = factory.newDocumentBuilder();
        Document document = domBuilder.parse(stream);
        NodeList nodeList = document.getElementsByTagName("student");
        for (i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Student student = new Student();
            student.setId(node.getAttributes().item(0).getTextContent() + "");
            NodeList childNodes = node.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                Node childNode = childNodes.item(j);
                if (node.getNodeType() != 1) continue;
                if (childNode.getNodeName().equals("name")) {
                    student.setName(childNode.getTextContent());
                    continue;
                }
                if (!childNode.getNodeName().equals("age")) continue;
                student.setAge(childNode.getTextContent());
            }
            this.students.add(student);
        }
        stream.close();
        if (this.students != null) {
            for (i = 0; i < this.students.size(); ++i) {
                Log.e((String)"msg", (String)("student: " + this.students.get(i).toString()));
            }
        }
    }

    public void getStudentsFromXMl2(InputStream stream) throws Exception {
        int i;
        this.students = new ArrayList<Student>();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder domBuilder = factory.newDocumentBuilder();
        Document document = domBuilder.parse(stream);
        NodeList nodeList = document.getElementsByTagName("student");
        for (i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            Student student = new Student();
            student.setId(element.getAttribute("id"));
            NodeList childNodes = element.getChildNodes();
            for (int j = 0; j < childNodes.getLength(); ++j) {
                if (childNodes.item(j).getNodeType() != 1) continue;
                Element childElement = (Element)childNodes.item(j);
                if (childElement.getNodeName().equals("name")) {
                    student.setName(childElement.getFirstChild().getNodeValue());
                    continue;
                }
                if (!childElement.getNodeName().equals("age")) continue;
                student.setAge(childElement.getFirstChild().getNodeValue());
            }
            this.students.add(student);
        }
        stream.close();
        if (this.students != null) {
            for (i = 0; i < this.students.size(); ++i) {
                Log.e((String)"msg", (String)("student: " + this.students.get(i).toString()));
            }
        }
    }
}

