/*
 * Decompiled with CFR 0.152.
 */
package com.bfcy.base.xml;

import android.os.Environment;
import android.util.Log;
import android.util.Xml;
import com.bfcy.base.beans.Person;
import com.bfcy.base.beans.Str;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class XmlMaker {
    public static void make(List<Person> list, OutputStream out) throws Exception, IllegalStateException, IOException {
        XmlSerializer serializer = Xml.newSerializer();
        serializer.setOutput(out, "utf-8");
        serializer.startDocument("utf-8", Boolean.valueOf(true));
        serializer.startTag(null, "Persons");
        for (Person person : list) {
            serializer.startTag(null, "person");
            serializer.attribute(null, "id", person.getId().toString());
            serializer.startTag(null, "name");
            serializer.text(person.getName());
            serializer.endTag(null, "name");
            serializer.startTag(null, "age");
            serializer.text(person.getAge().toString());
            serializer.endTag(null, "age");
            serializer.endTag(null, "person");
        }
        serializer.endTag(null, "Persons");
        serializer.endDocument();
        out.flush();
        out.close();
    }

    public static void makeStrXML(List<Str> strList, OutputStream outputStream) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        Object result = null;
        try {
            xmlSerializer.setOutput(outputStream, "utf-8");
            xmlSerializer.startDocument("utf-8", null);
            xmlSerializer.text("\n");
            xmlSerializer.startTag(null, "resources");
            xmlSerializer.text("\n");
            for (Str bean : strList) {
                xmlSerializer.text("\t");
                xmlSerializer.startTag(null, "string");
                xmlSerializer.attribute(null, "name", String.valueOf(bean.getName()));
                xmlSerializer.text(bean.getValue());
                xmlSerializer.endTag(null, "string");
                xmlSerializer.text("\n");
            }
            xmlSerializer.endTag(null, "resources");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
            outputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void makeStrXML(List<Str> strList, String fileName) {
        XmlSerializer xmlSerializer = Xml.newSerializer();
        File file = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_DOWNLOADS);
        FileOutputStream fileOutputStream = null;
        try {
            String outPutPath = file.getAbsolutePath() + "/" + fileName;
            Log.i((String)"tag", (String)outPutPath);
            File outFile = new File(outPutPath);
            if (outFile.exists()) {
                outFile.delete();
                outFile.createNewFile();
            } else {
                outFile.createNewFile();
            }
            fileOutputStream = new FileOutputStream(outFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Object result = null;
        try {
            xmlSerializer.setOutput(fileOutputStream, "utf-8");
            xmlSerializer.startDocument("utf-8", null);
            xmlSerializer.text("\n");
            xmlSerializer.startTag(null, "resources");
            xmlSerializer.text("\n");
            for (Str bean : strList) {
                xmlSerializer.text("\t");
                xmlSerializer.startTag(null, "string");
                xmlSerializer.attribute(null, "name", String.valueOf(bean.getName()));
                xmlSerializer.text(bean.getValue());
                xmlSerializer.endTag(null, "string");
                xmlSerializer.text("\n");
            }
            xmlSerializer.endTag(null, "resources");
            xmlSerializer.endDocument();
            xmlSerializer.flush();
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

