/*
 * Decompiled with CFR 0.152.
 */
package com.lzh.easythread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

final class DelayTaskDispatcher {
    private ScheduledExecutorService dispatcher = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("Delay-Task-Dispatcher");
            thread.setPriority(10);
            return thread;
        }
    });
    private static DelayTaskDispatcher instance = new DelayTaskDispatcher();

    private DelayTaskDispatcher() {
    }

    static DelayTaskDispatcher get() {
        return instance;
    }

    void postDelay(long delay, final ExecutorService pool, final Runnable task) {
        if (delay == 0L) {
            pool.execute(task);
            return;
        }
        this.dispatcher.schedule(new Runnable(){

            @Override
            public void run() {
                pool.execute(task);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }
}

