/*
 * Decompiled with CFR 0.152.
 */
package top.banner.lib.curl;

import java.util.HashSet;
import java.util.Set;

public class UrlPattern {
    private static final String EXTENSION_MAPPING_PATTERN = "*.";
    private static final String PATH_MAPPING_PATTERN = "/*";
    private static final Set<String> exactMatches = new HashSet<String>();
    private static final Set<String> startsWithMatches = new HashSet<String>();
    private static final Set<String> endsWithMatches = new HashSet<String>();

    public static void addUrlPattern(String urlPattern) {
        if (null == urlPattern) {
            return;
        }
        if (urlPattern.startsWith(EXTENSION_MAPPING_PATTERN)) {
            endsWithMatches.add(urlPattern.substring(1));
        } else if (urlPattern.equals(PATH_MAPPING_PATTERN)) {
            startsWithMatches.add("");
        } else if (urlPattern.endsWith(PATH_MAPPING_PATTERN)) {
            startsWithMatches.add(urlPattern.substring(0, urlPattern.length() - 1));
            exactMatches.add(urlPattern.substring(0, urlPattern.length() - 2));
        } else {
            if ("".equals(urlPattern)) {
                urlPattern = "/";
            }
            exactMatches.add(urlPattern);
        }
    }

    public static boolean matches(String requestPath) {
        for (String pattern : exactMatches) {
            if (!pattern.equals(requestPath)) continue;
            return true;
        }
        if (!requestPath.startsWith("/")) {
            return false;
        }
        for (String pattern : endsWithMatches) {
            if (!requestPath.endsWith(pattern)) continue;
            return true;
        }
        for (String pattern : startsWithMatches) {
            if (!requestPath.startsWith(pattern)) continue;
            return true;
        }
        return false;
    }
}

