/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class BinarySearch {
    private BinarySearch() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> long compute(T algebra, U value, IndexedDataSource<U> data) {
        Object tmp = algebra.construct();
        long lo = 0L;
        long hi = data.size() - 1L;
        while (hi >= lo) {
            long mid = (lo + hi) / 2L;
            data.get(mid, tmp);
            int cmp = ((Ordered<U>)algebra).compare().call(value, tmp);
            if (cmp == 0) {
                return mid;
            }
            if (cmp > 0) {
                lo = mid + 1L;
                continue;
            }
            hi = mid - 1L;
        }
        return -1L;
    }
}

