/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import java.math.BigInteger;
import nom.bdezonia.zorbage.procedure.Procedure3;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.MatrixMember;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class CartesianProduct {
    public static <T extends Algebra<T, U>, U, V extends Algebra<V, W>, W, X extends Algebra<X, Y>, Y> void compute(T algU, V algW, X algY, Procedure3<U, W, Y> proc, IndexedDataSource<U> a, IndexedDataSource<W> b, IndexedDataSource<Y> result) {
        if (a.size() <= 0L || b.size() <= 0L || result.size() <= 0L) {
            throw new IllegalArgumentException("input arrays must all be length >= 1");
        }
        if (!BigInteger.valueOf(result.size()).equals(BigInteger.valueOf(a.size()).multiply(BigInteger.valueOf(b.size())))) {
            throw new IllegalArgumentException("input arrays are not shape compatible");
        }
        Object u = algU.construct();
        Object w = algW.construct();
        Object y = algY.construct();
        long i = 0L;
        for (long r = 0L; r < a.size(); ++r) {
            a.get(r, u);
            for (long c = 0L; c < b.size(); ++c) {
                b.get(c, w);
                proc.call(u, w, y);
                result.set(i++, y);
            }
        }
    }

    public static <T extends Algebra<T, U>, U, V extends Algebra<V, W>, W, X extends Algebra<X, Y>, Y> void compute(T algU, V algW, X algY, Procedure3<U, W, Y> proc, RModuleMember<U> a, RModuleMember<W> b, MatrixMember<Y> result) {
        if (a.length() != result.rows() || b.length() != result.cols()) {
            throw new IllegalArgumentException("input array sizes do not match");
        }
        Object u = algU.construct();
        Object w = algW.construct();
        Object y = algY.construct();
        for (long r = 0L; r < a.length(); ++r) {
            a.v(r, u);
            for (long c = 0L; c < b.length(); ++c) {
                b.v(c, w);
                proc.call(u, w, y);
                result.setV(r, c, y);
            }
        }
    }
}

