/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.type.data.float64.complex.ComplexFloat64Member;

public class ComplexRootOfUnity {
    private ComplexRootOfUnity() {
    }

    public static void compute(int m, int n, ComplexFloat64Member root) {
        if (n < 1 || m < 1) {
            throw new IllegalArgumentException("arguments must be positive");
        }
        if (n > m) {
            throw new IllegalArgumentException("n outside bounds of [1,m]: n = " + n + " m = " + m);
        }
        ComplexFloat64Member e = G.CDBL.construct();
        ComplexFloat64Member power = G.CDBL.construct();
        ComplexFloat64Member two = G.CDBL.construct();
        ComplexFloat64Member I = G.CDBL.construct();
        ComplexFloat64Member M = G.CDBL.construct();
        ComplexFloat64Member N = G.CDBL.construct();
        two.setR(2.0);
        I.setI(1.0);
        M.setR(m);
        N.setR(n);
        G.CDBL.E().call(e);
        G.CDBL.PI().call(power);
        G.CDBL.multiply().call(power, two, power);
        G.CDBL.multiply().call(power, I, power);
        G.CDBL.divide().call(power, M, power);
        G.CDBL.multiply().call(power, N, power);
        G.CDBL.pow().call(e, power, root);
    }
}

