/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.multidim.MultiDimDataSource;
import nom.bdezonia.zorbage.multidim.NdData;
import nom.bdezonia.zorbage.predicate.Predicate;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.data.int1.UnsignedInt1Member;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class CreateMask {
    public static <T extends Algebra<T, U>, U> IndexedDataSource<UnsignedInt1Member> compute(T alg, Predicate<U> condition, IndexedDataSource<U> a) {
        Object value = alg.construct();
        UnsignedInt1Member zero = G.UINT1.construct();
        UnsignedInt1Member one = G.UINT1.construct();
        G.UINT1.unity().call(one);
        IndexedDataSource<UnsignedInt1Member> result = Storage.allocate(a.size(), zero);
        for (long i = 0L; i < a.size(); ++i) {
            a.get(i, value);
            if (condition.isTrue(value)) {
                result.set(i, one);
                continue;
            }
            result.set(i, zero);
        }
        return result;
    }

    public static <T extends Algebra<T, U>, U> MultiDimDataSource<UnsignedInt1Member> compute(T alg, Predicate<U> condition, MultiDimDataSource<U> a) {
        long[] dims = new long[a.numDimensions()];
        for (int i = 0; i < dims.length; ++i) {
            dims[i] = a.dimension(i);
        }
        IndexedDataSource<UnsignedInt1Member> data = CreateMask.compute(alg, condition, a.rawData());
        return new NdData<UnsignedInt1Member>(dims, data);
    }
}

