/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.RModule;
import nom.bdezonia.zorbage.type.algebra.RModuleMember;
import nom.bdezonia.zorbage.type.algebra.Ring;
import nom.bdezonia.zorbage.type.ctor.Constructible1dLong;
import nom.bdezonia.zorbage.type.ctor.StorageConstruction;

public class CrossProduct {
    private CrossProduct() {
    }

    public static <T extends RModule<T, U, V, W> & Constructible1dLong<U>, U extends RModuleMember<W>, V extends Ring<V, W>, W> void compute(T rmodAlgebra, V memberAlgebra, U a, U b, U c) {
        if (a.length() != 3L || b.length() != 3L) {
            throw new UnsupportedOperationException("vector cross product defined for 3 dimensions");
        }
        RModuleMember tmp = (RModuleMember)((Constructible1dLong<U>)rmodAlgebra).construct(StorageConstruction.MEM_ARRAY, 3L);
        Object atmp = memberAlgebra.construct();
        Object btmp = memberAlgebra.construct();
        Object term1 = memberAlgebra.construct();
        Object term2 = memberAlgebra.construct();
        Object t = memberAlgebra.construct();
        a.v(1L, atmp);
        b.v(2L, btmp);
        memberAlgebra.multiply().call(atmp, btmp, term1);
        a.v(2L, atmp);
        b.v(1L, btmp);
        memberAlgebra.multiply().call(atmp, btmp, term2);
        memberAlgebra.subtract().call(term1, term2, t);
        tmp.setV(0L, t);
        a.v(2L, atmp);
        b.v(0L, btmp);
        memberAlgebra.multiply().call(atmp, btmp, term1);
        a.v(0L, atmp);
        b.v(2L, btmp);
        memberAlgebra.multiply().call(atmp, btmp, term2);
        memberAlgebra.subtract().call(term1, term2, t);
        tmp.setV(1L, t);
        a.v(0L, atmp);
        b.v(1L, btmp);
        memberAlgebra.multiply().call(atmp, btmp, term1);
        a.v(1L, atmp);
        b.v(0L, btmp);
        memberAlgebra.multiply().call(atmp, btmp, term2);
        memberAlgebra.subtract().call(term1, term2, t);
        tmp.setV(2L, t);
        rmodAlgebra.assign().call(tmp, c);
    }
}

