/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.sampling.IntegerIndex;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConversion;
import nom.bdezonia.zorbage.type.data.universal.PrimitiveConverter;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.TrimmedDataSource;

public class DataConvert {
    private DataConvert() {
    }

    public static <T extends Algebra<T, U>, U extends PrimitiveConversion, V extends Algebra<V, W>, W extends PrimitiveConversion> void compute(T fromAlgebra, V toAlgebra, IndexedDataSource<U> fromList, IndexedDataSource<W> toList) {
        int i;
        long toSize;
        long fromSize = fromList.size();
        if (fromSize > (toSize = toList.size())) {
            throw new IllegalArgumentException("mismatched list sizes");
        }
        int maxPieces = Runtime.getRuntime().availableProcessors();
        if ((long)maxPieces > fromSize) {
            maxPieces = 1;
        }
        long start = 0L;
        long count = fromSize / (long)maxPieces;
        Thread[] threads = new Thread[maxPieces];
        for (i = 0; i < maxPieces; ++i) {
            if (i == maxPieces - 1) {
                count = fromSize - start;
            }
            Computer<T, U, V, W> computer = new Computer<T, U, V, W>(fromAlgebra, toAlgebra, start, count, fromList, toList);
            threads[i] = new Thread(computer);
            start += count;
        }
        for (i = 0; i < threads.length; ++i) {
            threads[i].start();
        }
        try {
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
            }
        }
        catch (InterruptedException e) {
            throw new IllegalArgumentException("ouch");
        }
    }

    private static class Computer<T extends Algebra<T, U>, U extends PrimitiveConversion, V extends Algebra<V, W>, W extends PrimitiveConversion>
    implements Runnable {
        private final T algU;
        private final V algW;
        private final IndexedDataSource<U> src;
        private final IndexedDataSource<W> dst;

        public Computer(T algU, V algW, long start, long count, IndexedDataSource<U> src, IndexedDataSource<W> dst) {
            this.algU = algU;
            this.algW = algW;
            this.src = new TrimmedDataSource<U>(src, start, count);
            this.dst = new TrimmedDataSource<W>(dst, start, count);
        }

        @Override
        public void run() {
            PrimitiveConversion from = (PrimitiveConversion)this.algU.construct();
            PrimitiveConversion to = (PrimitiveConversion)this.algW.construct();
            int numD = Math.max(from.numDimensions(), to.numDimensions());
            IntegerIndex tmp1 = new IntegerIndex(numD);
            IntegerIndex tmp2 = new IntegerIndex(numD);
            IntegerIndex tmp3 = new IntegerIndex(numD);
            long fromSize = this.src.size();
            for (long i = 0L; i < fromSize; ++i) {
                this.src.get(i, from);
                PrimitiveConverter.convert(tmp1, tmp2, tmp3, from, to);
                this.dst.set(i, to);
            }
        }
    }
}

