/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.BitOperations;
import nom.bdezonia.zorbage.type.algebra.Bounded;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class DivMod {
    private DivMod() {
    }

    public static <T extends Algebra<T, U> & Ordered<U> & Addition<U> & Bounded<U>, U> void compute(T alg, U a, U b, U d, U m) {
        if (alg.isZero().call(b).booleanValue()) {
            throw new IllegalArgumentException("divide by zero");
        }
        Object zero = alg.construct();
        Object one = alg.construct();
        Object min = alg.construct();
        ((Unity)alg).unity().call(one);
        ((Bounded<U>)alg).minBound().call(min);
        if (((Ordered<U>)alg).isLess().call(min, zero).booleanValue()) {
            boolean bPos;
            boolean aPos;
            if (alg.isEqual().call(one, b).booleanValue()) {
                alg.assign().call(a, d);
                alg.zero().call(m);
                return;
            }
            Object aNeg = alg.construct();
            Object bNeg = alg.construct();
            if (((Ordered<U>)alg).isGreater().call(a, zero).booleanValue()) {
                aPos = true;
                ((Addition<U>)alg).negate().call(a, aNeg);
            } else {
                aPos = false;
                alg.assign().call(a, aNeg);
            }
            if (((Ordered<U>)alg).isGreater().call(b, zero).booleanValue()) {
                bPos = true;
                ((Addition<U>)alg).negate().call(b, bNeg);
            } else {
                bPos = false;
                alg.assign().call(b, bNeg);
            }
            if (((Ordered<U>)alg).isGreater().call(aNeg, bNeg).booleanValue()) {
                if (aPos) {
                    ((Addition<U>)alg).negate().call(aNeg, aNeg);
                }
                alg.assign().call(zero, d);
                alg.assign().call(aNeg, m);
                return;
            }
            Object c = alg.construct();
            DivMod.largestDoubling(alg, ((Ordered<U>)alg).isLessEqual(), aNeg, bNeg, c);
            Object n = alg.construct(one);
            ((Addition<U>)alg).subtract().call(aNeg, c, aNeg);
            while (!alg.isEqual().call(c, bNeg).booleanValue()) {
                ((BitOperations)alg).bitShiftRight().call(1, c, c);
                ((Addition<U>)alg).add().call(n, n, n);
                if (!((Ordered<U>)alg).isGreaterEqual().call(c, aNeg).booleanValue()) continue;
                ((Addition<U>)alg).subtract().call(aNeg, c, aNeg);
                ((Addition<U>)alg).add().call(n, one, n);
            }
            if (aPos != bPos) {
                ((Addition<U>)alg).negate().call(n, n);
            }
            if (aPos) {
                ((Addition<U>)alg).negate().call(aNeg, aNeg);
            }
            alg.assign().call(n, d);
            alg.assign().call(aNeg, m);
        } else {
            U aPos = alg.construct(a);
            U bPos = alg.construct(b);
            if (((Ordered<U>)alg).isLess().call(aPos, bPos).booleanValue()) {
                alg.assign().call(zero, d);
                alg.assign().call(aPos, m);
                return;
            }
            Object c = alg.construct();
            DivMod.largestDoubling(alg, ((Ordered<U>)alg).isGreaterEqual(), aPos, bPos, c);
            Object n = alg.construct(one);
            ((Addition<U>)alg).subtract().call(aPos, c, aPos);
            while (!alg.isEqual().call(c, bPos).booleanValue()) {
                ((BitOperations)alg).bitShiftRight().call(1, c, c);
                ((Addition<U>)alg).add().call(n, n, n);
                if (!((Ordered<U>)alg).isLessEqual().call(c, aPos).booleanValue()) continue;
                ((Addition<U>)alg).subtract().call(aPos, c, aPos);
                ((Addition<U>)alg).add().call(n, one, n);
            }
            alg.assign().call(n, d);
            alg.assign().call(aPos, m);
        }
    }

    private static <T extends Algebra<T, U> & Ordered<U>, U> void largestDoubling(T alg, Function2<Boolean, U, U> test, U a, U b, U c) {
        U tmpB = alg.construct(b);
        Object diff = alg.construct();
        ((Addition)alg).subtract().call(a, tmpB, diff);
        while (test.call(diff, tmpB).booleanValue()) {
            ((Addition)alg).add().call(tmpB, tmpB, tmpB);
            ((Addition)alg).subtract().call(a, tmpB, diff);
        }
        alg.assign().call(tmpB, c);
    }
}

