/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Factorial;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.Power;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class EstimateErf {
    private EstimateErf() {
    }

    public static <T extends Algebra<T, U> & Unity<U> & Multiplication<U> & Power<U> & Roots<U>, U> void compute(T alg, int numTerms, U input, U result) {
        if (numTerms <= 0) {
            throw new IllegalArgumentException("numTerms must be greater than zero");
        }
        Object zero = alg.construct();
        Object tmp = alg.construct();
        Object n = alg.construct();
        Object one = alg.construct();
        Object minus_one = alg.construct();
        Object two = alg.construct();
        Object minus_one_to_the_n = alg.construct();
        Object two_n_plus_one = alg.construct();
        Object n_factorial = alg.construct();
        Object powTerm = alg.construct();
        Object numer = alg.construct();
        Object denom = alg.construct();
        Object term = alg.construct();
        Object sum = alg.construct();
        ((Unity<U>)alg).unity().call(one);
        ((Addition)alg).add().call(one, one, two);
        ((Addition)alg).subtract().call(zero, one, minus_one);
        alg.assign().call(minus_one, minus_one_to_the_n);
        for (int i = 0; i < numTerms; ++i) {
            ((Multiplication<U>)alg).multiply().call(minus_one_to_the_n, minus_one, minus_one_to_the_n);
            ((Multiplication<U>)alg).multiply().call(two, n, tmp);
            ((Addition)alg).add().call(tmp, one, two_n_plus_one);
            ((Power<U>)alg).pow().call(input, two_n_plus_one, powTerm);
            Factorial.compute(alg, i, n_factorial);
            ((Multiplication<U>)alg).multiply().call(minus_one_to_the_n, powTerm, numer);
            ((Multiplication<U>)alg).multiply().call(n_factorial, two_n_plus_one, denom);
            ((Invertible)alg).divide().call(numer, denom, term);
            ((Addition)alg).add().call(sum, term, sum);
            ((Addition)alg).add().call(n, one, n);
        }
        Object sqrt_pi = alg.construct();
        ((RealConstants)alg).PI().call(tmp);
        ((Roots<U>)alg).sqrt().call(tmp, sqrt_pi);
        ((Invertible)alg).divide().call(sum, sqrt_pi, sum);
        ((Multiplication<U>)alg).multiply().call(sum, two, sum);
        alg.assign().call(sum, result);
    }
}

