/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.SetComplex;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.algebra.Unity;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class FFT {
    private FFT() {
    }

    public static <T extends Algebra<T, U> & Addition<U>, U extends SetComplex<W>, V extends Algebra<V, W> & Trigonometric<W> & Multiplication<W> & Invertible<W>, W> void compute(T cmplxAlg, V realAlg, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        long aSize = a.size();
        long bSize = b.size();
        if (aSize != FFT.enclosingPowerOf2(aSize)) {
            throw new IllegalArgumentException("input size is not a power of 2");
        }
        if (aSize != bSize) {
            throw new IllegalArgumentException("output size does not match input size");
        }
        SetComplex tmp1 = (SetComplex)cmplxAlg.construct();
        SetComplex tmp2 = (SetComplex)cmplxAlg.construct();
        int shift = 1 + Long.numberOfLeadingZeros(aSize);
        for (long k = 0L; k < aSize; ++k) {
            long j = Long.reverse(k) >>> shift;
            a.get(j, tmp1);
            a.get(k, tmp2);
            if (j < k) {
                b.set(k, tmp1);
                b.set(j, tmp2);
                continue;
            }
            b.set(j, tmp1);
            b.set(k, tmp2);
        }
        SetComplex w = (SetComplex)cmplxAlg.construct();
        SetComplex tao = (SetComplex)cmplxAlg.construct();
        Object pi = realAlg.construct();
        ((RealConstants)realAlg).PI().call(pi);
        Object cos = realAlg.construct();
        Object sin = realAlg.construct();
        Object one = realAlg.construct();
        Object two = realAlg.construct();
        ((Unity)realAlg).unity().call(one);
        ((Addition)realAlg).add().call(one, one, two);
        Object l = realAlg.construct(two);
        for (long el = 2L; el <= aSize; el += el) {
            Object k = realAlg.construct();
            Object kth = realAlg.construct();
            for (long kay = 0L; kay < el / 2L; ++kay) {
                ((Addition)realAlg).negate().call(two, kth);
                ((Multiplication<W>)realAlg).multiply().call(kth, k, kth);
                ((Multiplication<W>)realAlg).multiply().call(kth, pi, kth);
                ((Invertible<W>)realAlg).divide().call(kth, l, kth);
                ((Trigonometric<W>)realAlg).cos().call(kth, cos);
                ((Trigonometric<W>)realAlg).sin().call(kth, sin);
                w.setR(cos);
                w.setI(sin);
                for (long j = 0L; j < aSize / el; ++j) {
                    b.get(j * el + kay + el / 2L, tmp1);
                    ((Multiplication)cmplxAlg).multiply().call(w, tmp1, tao);
                    b.get(j * el + kay, tmp2);
                    ((Addition<U>)cmplxAlg).subtract().call(tmp2, tao, tmp1);
                    b.set(j * el + kay + el / 2L, tmp1);
                    ((Addition<U>)cmplxAlg).add().call(tmp2, tao, tmp1);
                    b.set(j * el + kay, tmp1);
                }
                ((Addition)realAlg).add().call(k, one, k);
            }
            ((Addition)realAlg).add().call(l, l, l);
        }
    }

    public static long enclosingPowerOf2(long num) {
        if (num <= 0L) {
            throw new IllegalArgumentException("num too small");
        }
        long max = 1L;
        for (int i = 0; i < 63; ++i) {
            if (num <= max) {
                return max;
            }
            max <<= 1;
        }
        throw new IllegalArgumentException("number passed (" + num + ") does not have an enclosing power of two that fits into a positive long");
    }
}

