/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class Factorial {
    private Factorial() {
    }

    public static <T extends Algebra<T, U> & Unity<U> & Multiplication<U>, U> void compute(T algebra, int n, U result) {
        if (n < 0) {
            throw new IllegalArgumentException("factorial not defined for negative input");
        }
        if (n == 0 || n == 1) {
            ((Unity<U>)algebra).unity().call(result);
        } else {
            Object tmp = algebra.construct();
            Object factor = algebra.construct();
            Object one = algebra.construct();
            ((Unity<U>)algebra).unity().call(one);
            algebra.assign().call(one, tmp);
            algebra.assign().call(one, factor);
            for (int i = 2; i <= n; ++i) {
                ((Addition)algebra).add().call(factor, one, factor);
                ((Multiplication<U>)algebra).multiply().call(tmp, factor, tmp);
            }
            algebra.assign().call(tmp, result);
        }
    }
}

