/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class Fibonacci {
    private Fibonacci() {
    }

    public static <T extends Algebra<T, U> & Addition<U> & Ordered<U>, U> void compute(T algebra, int n, U result) {
        if (n < 0) {
            throw new IllegalArgumentException("Cannot get fibonacci value of negative input");
        }
        if (n == 0) {
            algebra.zero().call(result);
        } else if (n == 1) {
            ((Unity)algebra).unity().call(result);
        } else {
            Object prev2 = algebra.construct();
            Object prev1 = algebra.construct();
            ((Unity)algebra).unity().call(prev1);
            Object tmp = algebra.construct();
            for (int i = 2; i <= n; ++i) {
                ((Addition<U>)algebra).add().call(prev2, prev1, tmp);
                algebra.assign().call(prev1, prev2);
                algebra.assign().call(tmp, prev1);
            }
            algebra.assign().call(tmp, result);
        }
    }
}

