/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.procedure.Procedure2;
import nom.bdezonia.zorbage.type.algebra.Algebra;

public class FindFixedPoint<T extends Algebra<T, U>, U>
implements Function2<Long, U, U> {
    private final Algebra<T, U> alg;
    private final Procedure2<U, U> proc;
    private final Function2<Boolean, U, U> closeEnough;
    private long maxIters;

    public FindFixedPoint(T alg, Procedure2<U, U> proc, Function2<Boolean, U, U> closeEnough, long maxIters) {
        this.alg = alg;
        this.proc = proc;
        this.closeEnough = closeEnough;
        this.maxIters = maxIters;
        if (maxIters < 1L) {
            throw new IllegalArgumentException("maxIters must be > 0");
        }
    }

    public long getMaxIters() {
        return this.maxIters;
    }

    public void setMaxIters(long maxIters) {
        if (maxIters < 1L) {
            throw new IllegalArgumentException("maxIters must be > 0");
        }
        this.maxIters = maxIters;
    }

    @Override
    public Long call(U firstGuess, U result) {
        U guess = this.alg.construct(firstGuess);
        Object tmp = this.alg.construct();
        return this.iterate(guess, tmp, this.maxIters, result);
    }

    private long iterate(U guess, U tmp, long iters, U result) {
        for (long i = 0L; i < iters; ++i) {
            this.proc.call(guess, tmp);
            if (this.closeEnough.call(guess, tmp).booleanValue()) {
                this.alg.assign().call(guess, result);
                return i;
            }
            this.alg.assign().call(tmp, guess);
        }
        return -1L;
    }
}

