/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.Multiplication;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.algebra.Roots;
import nom.bdezonia.zorbage.type.algebra.Unity;

public class Gaussian {
    private Gaussian() {
    }

    public static <T extends Algebra<T, U> & Addition<U> & Exponential<U> & RealConstants<U> & Invertible<U>, U> void compute(T alg, U mu, U sigma, U x, U result) {
        if (((Ordered)alg).signum().call(sigma) < 0) {
            throw new IllegalArgumentException("sigma must be >= 0");
        }
        Object one = alg.construct();
        Object two = alg.construct();
        Object pi = alg.construct();
        Object two_pi = alg.construct();
        Object root_two_pi = alg.construct();
        Object scale = alg.construct();
        Object exp = alg.construct();
        Object numer = alg.construct();
        Object denom = alg.construct();
        ((Unity)alg).unity().call(one);
        ((Addition<U>)alg).add().call(one, one, two);
        ((RealConstants<U>)alg).PI().call(pi);
        ((Multiplication)alg).multiply().call(two, pi, two_pi);
        ((Roots)alg).sqrt().call(two_pi, root_two_pi);
        ((Multiplication)alg).multiply().call(root_two_pi, sigma, scale);
        ((Invertible<U>)alg).divide().call(one, scale, scale);
        ((Addition<U>)alg).subtract().call(x, mu, numer);
        ((Multiplication)alg).multiply().call(numer, numer, numer);
        ((Addition<U>)alg).negate().call(numer, numer);
        ((Multiplication)alg).multiply().call(sigma, sigma, denom);
        ((Multiplication)alg).multiply().call(two, denom, denom);
        ((Invertible<U>)alg).divide().call(numer, denom, exp);
        ((Exponential<U>)alg).exp().call(exp, exp);
        ((Multiplication)alg).multiply().call(scale, exp, result);
    }
}

