/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.algorithm.Gaussian;
import nom.bdezonia.zorbage.algorithm.Scale;
import nom.bdezonia.zorbage.algorithm.Sum;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Exponential;
import nom.bdezonia.zorbage.type.algebra.Invertible;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.algebra.RealConstants;
import nom.bdezonia.zorbage.type.ctor.Allocatable;
import nom.bdezonia.zorbage.type.storage.Storage;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class GaussianFilter1D {
    private GaussianFilter1D() {
    }

    public static <T extends Algebra<T, U> & Addition<U> & Exponential<U> & RealConstants<U> & Invertible<U>, U extends Allocatable<U>> IndexedDataSource<U> compute(T alg, int radius, U sigma) {
        if (radius < 0) {
            throw new IllegalArgumentException("radius must be >= 0");
        }
        if (((Ordered)alg).signum().call(sigma) < 0) {
            throw new IllegalArgumentException("sigma must be >= 0");
        }
        Allocatable mu = (Allocatable)alg.construct();
        Allocatable val = (Allocatable)alg.construct();
        IndexedDataSource<Allocatable> result = Storage.allocate(radius * 2 + 1, val);
        Allocatable x = (Allocatable)alg.construct();
        Gaussian.compute(alg, mu, sigma, x, val);
        result.set(radius, val);
        for (int i = 1; i <= radius; ++i) {
            x = (Allocatable)((Object)alg.construct((String)Integer.toString(i)));
            Gaussian.compute(alg, mu, sigma, x, val);
            result.set(radius - 1, val);
            result.set(radius + 1, val);
        }
        Sum.compute(alg, result, val);
        ((Invertible<U>)alg).invert().call(val, val);
        Scale.compute(alg, val, result, result);
        return result;
    }
}

