/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.procedure.Procedure;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;
import nom.bdezonia.zorbage.type.storage.datasource.TrimmedDataSource;

public class Generate {
    private Generate() {
    }

    public static <T extends Algebra<T, U>, U> void compute(T algU, Procedure<U> proc, IndexedDataSource<U> a, U ... inputs) {
        int i;
        int numProcs;
        long aSize = a.size();
        if (aSize < (long)(numProcs = Runtime.getRuntime().availableProcessors())) {
            numProcs = (int)aSize;
        }
        Thread[] threads = new Thread[numProcs];
        long thOffset = 0L;
        long slice = aSize / (long)numProcs;
        for (i = 0; i < numProcs; ++i) {
            long thSize = i != numProcs - 1 ? slice : aSize;
            TrimmedDataSource<U> aTrimmed = new TrimmedDataSource<U>(a, thOffset, thSize);
            Computer<T, U> r = new Computer<T, U>(algU, proc, aTrimmed, inputs);
            threads[i] = new Thread(r);
            thOffset += slice;
            aSize -= slice;
        }
        for (i = 0; i < numProcs; ++i) {
            threads[i].start();
        }
        for (i = 0; i < numProcs; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw new IllegalArgumentException("Thread execution error in Generate");
            }
        }
    }

    private static class Computer<T extends Algebra<T, U>, U>
    implements Runnable {
        private final T algebraU;
        private final IndexedDataSource<U> list;
        private final Procedure<U> proc;
        private final U[] inputs;

        Computer(T algU, Procedure<U> proc, IndexedDataSource<U> a, U[] inputs) {
            this.algebraU = algU;
            this.list = a;
            this.proc = proc;
            this.inputs = inputs;
        }

        @Override
        public void run() {
            Object tmp = this.algebraU.construct();
            for (long i = 0L; i < this.list.size(); ++i) {
                this.proc.call(tmp, this.inputs);
                this.list.set(i, tmp);
            }
        }
    }
}

