/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import java.math.BigDecimal;
import java.math.MathContext;
import nom.bdezonia.zorbage.algorithm.Conjugate;
import nom.bdezonia.zorbage.algorithm.FFT;
import nom.bdezonia.zorbage.algorithm.Scale;
import nom.bdezonia.zorbage.type.algebra.Addition;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.SetComplex;
import nom.bdezonia.zorbage.type.algebra.Trigonometric;
import nom.bdezonia.zorbage.type.algebra.Unity;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class InvFFT {
    private InvFFT() {
    }

    public static <T extends Algebra<T, U> & Addition<U> & nom.bdezonia.zorbage.type.algebra.Conjugate<U>, U extends SetComplex<W>, V extends Algebra<V, W> & Trigonometric<W> & Unity<W> & Addition<W>, W> void compute(T cmplxAlg, V realAlg, IndexedDataSource<U> a, IndexedDataSource<U> b) {
        long aSize = a.size();
        long bSize = b.size();
        if (aSize != FFT.enclosingPowerOf2(aSize)) {
            throw new IllegalArgumentException("input size is not a power of 2");
        }
        if (aSize != bSize) {
            throw new IllegalArgumentException("output size does not match input size");
        }
        SetComplex one_over_n = (SetComplex)((Object)cmplxAlg.construct((String)BigDecimal.ONE.divide(BigDecimal.valueOf(aSize), new MathContext(100)).toString()));
        Conjugate.compute(cmplxAlg, a, b);
        FFT.compute(cmplxAlg, realAlg, b, b);
        Conjugate.compute(cmplxAlg, b, b);
        Scale.compute(cmplxAlg, one_over_n, b, b);
    }
}

