/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class IsSorted {
    private IsSorted() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> boolean compute(T alg, IndexedDataSource<U> storage) {
        return IsSorted.checkSort(alg, ((Ordered<U>)alg).isLess(), storage);
    }

    public static <T extends Algebra<T, U>, U> boolean compute(T alg, Function2<Boolean, U, U> isLeftOf, IndexedDataSource<U> storage) {
        return IsSorted.checkSort(alg, isLeftOf, storage);
    }

    private static <T extends Algebra<T, U>, U> boolean checkSort(T alg, Function2<Boolean, U, U> isLeftOf, IndexedDataSource<U> storage) {
        Object value1 = alg.construct();
        Object value2 = alg.construct();
        long sz = storage.size();
        if (sz < 2L) {
            return true;
        }
        storage.get(0L, value1);
        for (long i = 1L; i < sz; ++i) {
            storage.get(i, value2);
            if (!isLeftOf.call(value1, value2).booleanValue() && isLeftOf.call(value1, value2) != isLeftOf.call(value2, value1)) {
                return false;
            }
            alg.assign().call(value2, value1);
        }
        return true;
    }
}

