/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import nom.bdezonia.zorbage.function.Function2;
import nom.bdezonia.zorbage.type.algebra.Algebra;
import nom.bdezonia.zorbage.type.algebra.Ordered;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class IsSortedUntil {
    private IsSortedUntil() {
    }

    public static <T extends Algebra<T, U> & Ordered<U>, U> long compute(T alg, IndexedDataSource<U> storage) {
        return IsSortedUntil.checkSort(alg, ((Ordered<U>)alg).isLess(), storage);
    }

    public static <T extends Algebra<T, U>, U> long compute(T alg, Function2<Boolean, U, U> isLeftOf, IndexedDataSource<U> storage) {
        return IsSortedUntil.checkSort(alg, isLeftOf, storage);
    }

    private static <T extends Algebra<T, U>, U> long checkSort(T alg, Function2<Boolean, U, U> isLeftOf, IndexedDataSource<U> storage) {
        Object tmp1 = alg.construct();
        Object tmp2 = alg.construct();
        long first = 0L;
        long last = storage.size();
        if (first == last) {
            return first;
        }
        long next = first;
        while (++next != last) {
            storage.get(next, tmp1);
            storage.get(first, tmp2);
            if (isLeftOf.call(tmp1, tmp2).booleanValue()) {
                return next;
            }
            ++first;
        }
        return last;
    }
}

