/*
 * Decompiled with CFR 0.152.
 */
package nom.bdezonia.zorbage.algorithm;

import java.util.ArrayList;
import nom.bdezonia.zorbage.algebras.G;
import nom.bdezonia.zorbage.algorithm.PointDistance;
import nom.bdezonia.zorbage.type.data.float64.real.Float64Member;
import nom.bdezonia.zorbage.type.data.int32.SignedInt32Member;
import nom.bdezonia.zorbage.type.data.point.Point;
import nom.bdezonia.zorbage.type.data.point.PointAlgebra;
import nom.bdezonia.zorbage.type.storage.datasource.IndexedDataSource;

public class KMeans {
    private KMeans() {
    }

    public static void compute(PointAlgebra algebra, int numClusters, IndexedDataSource<Point> points, IndexedDataSource<SignedInt32Member> clusterIndices) {
        long clusterIndicesSize;
        if (numClusters < 1) {
            throw new IllegalArgumentException("kmeans: illegal number of clusters. must be >= 1.");
        }
        long pointsSize = points.size();
        if (pointsSize != (clusterIndicesSize = clusterIndices.size())) {
            throw new IllegalArgumentException("points and clusterIndices length must match");
        }
        if (pointsSize < (long)numClusters) {
            throw new IllegalArgumentException("number of points given must be >= to the number of clusters");
        }
        int MAX_ITERS = 1000;
        Point point = algebra.construct();
        SignedInt32Member clusterNum = G.INT32.construct();
        Float64Member scale = G.DBL.construct();
        Float64Member dist = G.DBL.construct();
        Float64Member minDist = G.DBL.construct();
        for (long i = 0L; i < clusterIndicesSize; ++i) {
            clusterNum.setV((int)(i % (long)numClusters));
            clusterIndices.set(i, clusterNum);
        }
        points.get(0L, point);
        ArrayList<Point> centers = new ArrayList<Point>();
        ArrayList<Long> counts = new ArrayList<Long>();
        for (int i = 0; i < numClusters; ++i) {
            centers.add(new Point(point.numDimensions()));
            counts.add(new Long(0L));
        }
        for (int k = 0; k < MAX_ITERS; ++k) {
            int i;
            for (i = 0; i < numClusters; ++i) {
                algebra.zero().call((Point)centers.get(i));
            }
            for (long i2 = 0L; i2 < pointsSize; ++i2) {
                points.get(i2, point);
                clusterIndices.get(i2, clusterNum);
                Point ctrSum = (Point)centers.get(clusterNum.v());
                algebra.add().call(ctrSum, point, ctrSum);
                counts.set(clusterNum.v(), (Long)counts.get(clusterNum.v()) + 1L);
            }
            for (i = 0; i < numClusters; ++i) {
                Point ctrSum = (Point)centers.get(i);
                long count = (Long)counts.get(i);
                scale.setV(1.0 / (double)count);
                algebra.scale().call(scale, ctrSum, ctrSum);
            }
            boolean converged = true;
            for (long i3 = 0L; i3 < pointsSize; ++i3) {
                points.get(i3, point);
                Point clusterCtr = (Point)centers.get(0);
                PointDistance.compute(point, clusterCtr, minDist);
                int minCluster = 0;
                for (int j = 1; j < numClusters; ++j) {
                    Point ctr = (Point)centers.get(j);
                    PointDistance.compute(point, ctr, dist);
                    if (!G.DBL.isLess().call(dist, minDist).booleanValue()) continue;
                    G.DBL.assign().call(dist, minDist);
                    minCluster = j;
                }
                clusterIndices.get(i3, clusterNum);
                if (minCluster == clusterNum.v()) continue;
                converged = false;
                clusterNum.setV(minCluster);
                clusterIndices.set(i3, clusterNum);
            }
            if (!converged) continue;
            return;
        }
        System.out.println("Did not converge after " + MAX_ITERS + " iterations. Best approximation returned.");
    }
}

